/***************************************************************************
                          kfilereplace.h  -  description
                             -------------------
    begin                : sam oct 16 15:28:00 CEST 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEREPLACE_H
#define KFILEREPLACE_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE 
#include <klocale.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kdebug.h>

// include files for Qt
#include <qstringlist.h>

// application includes
#include "apistruct.h"
#include "kresultview.h"

// general unix includes
//#include <pthread.h>

// forward declaration of the KFileReplace classes
class KFileReplaceDoc;
class KFileReplaceView;
class ResultView;
class QDropEvent;
class QDragEnterEvent;
class KAboutKFileReplace;
class KURL;

// Global Thread data
extern bool g_bThreadRunning;
extern bool g_bThreadMustStop;
extern int g_nFilesRep;
extern RepDirArg g_argu;
extern char g_szErrMsg[];
extern int g_nStringsRep;
extern int g_nOperation;
extern KApplication *g_app;
//extern pthread_t g_threadReplace;

typedef unsigned short int UINT;
typedef unsigned long int DWORD;
typedef unsigned long long int QWORD;
typedef unsigned char BYTE;

void showDebugMsg(DWORD dwDebugLevel, const char *szFile,
		  const char *szFunction, int nLine, const char *fmt, ...);
#define showDebug(level, format, args...) showDebugMsg(level, __FILE__, __FUNCTION__, __LINE__, format, ## args)

// =============================================================
class KFileReplaceApp : public KTMainWindow
{
  Q_OBJECT

 public:
  KFileReplaceApp(QString strArguDir=QString::null, QString strArguFilter=QString::null);
  ~KFileReplaceApp();
  void updateCommands();
  void loadStringFile(QString strFilename);
  KFileReplaceDoc* getDocument() const; 	
  KSettings getSettings() {return m_settings;}
  void setSettings(KSettings settings) {m_settings = settings;}
  KConfig *getConfig() {return m_config;}
  QListView *getStringView();
  KResultView *getResultView();
  
 protected:
  void saveOptions();
  void readOptions();
  void initGUI();
  void initStatusBar();
  void initDocument(QString strArguDir, QString strArguFilter);
  void initView();
  
  public slots:
  void slotFileNew();
  void slotFileQuit();
  void slotViewToolBar();
  void slotViewStatusBar();
  void slotStatusMsg(const char *text);
  void slotStatusHelpMsg(const char *text);
  void slotFileSearch();
  void slotFileSimulate();
  void slotFileReplace();
  void slotFileStop();
  void slotFileSave();
  void slotStringsAdd();
  void slotStringsDel();
  void slotStringsEmpty();
  void slotStringsEdit();
  void slotStringsSave();
  void slotStringsLoad();
  void slotStringsInvertCur();
  void slotStringsInvertAll();
  void slotOptionsRecursive();
  void slotOptionsBackup();
  void slotOptionsCaseSensitive();
  void slotOptionsWildcards();
  void slotOptionsVariables();
  void slotOptionsPreferences();
  void timerEvent(QTimerEvent *);
  void closeEvent ( QCloseEvent *);
  void showAboutApplication(void);
  void slotOpenRecentStringFile(const KURL& urlFile);	
  void slotFileConfigureToolbars();
  void appHelpActivated();
  void contextHelpActivated();
  void aboutKDE();
  void reportBug();
  
 private:
  int checkBeforeOperation(int nTypeOfOperation);
  void setWhatsThis();
	
 protected:
  void dropEvent(QDropEvent *event);
  void dragEnterEvent(QDragEnterEvent *event);
	
 private:
  /** the configuration object of the application */
  KConfig* m_config;
  /** file_menu contains all items of the menubar entry "File" */
  /** view is the main widget which represents your working area. The View
   * class should handle all events of the view widget.  It is kept empty so
   * you can create your view according to your application's needs by
   * changing the view class. */
  KFileReplaceView *m_view;
  /** doc represents your actual document and is created only once. It keeps
   * information such as filename and does the serialization of your files.
   */
  KFileReplaceDoc *m_doc;
  QStringList m_recentStringFileList; // a list of recently accessed files
  KSettings m_settings;
  KAboutKFileReplace *m_dlgAbout;
  
};

#endif // KFILEREPLACE_H

































