#ifndef CUPSPARSERWINDOW_H
#define CUPSPARSERWINDOW_H

#include <kmainwindow.h>

class CupsParserView;
class QListViewItem;

class CupsParserWindow : public KMainWindow
{
	Q_OBJECT
public:
	enum WindowType { Access, Error, Page };
	CupsParserWindow( WindowType type = Error, QWidget *parent = 0, const char *name = 0 );
	~CupsParserWindow();

	WindowType type() const;
	static void restoreWindows();

protected slots:
	void stopParsing();
	void resumeParsing();
	void restartParsing();
	void selectionChanged();
	void showWindow();
	void itemsChanged( int );
	void closeAll();
	void rightButtonPressed( QListViewItem*, const QPoint&, int );
	void error( const QString& );
	void configure();

protected:
	void initActions();

private:
	CupsParserView *m_view;
	WindowType m_type;
};

#endif /* CUPSPARSERWINDOW_H */
