#include "mainwidget.h"



BEGIN_WMPROCLIST(MyMainWidget)
//  WM_PROC(ID_FILE_QUIT , )
  WM_PROC(ID_FILE_NEW,            file_new)
  WM_PROC(ID_FILE_LOAD,           file_load);
  WM_PROC(ID_FILE_SAVE,           file_save);
  WM_PROC(ID_FILE_SAVE_AS,        file_save_as);
  WM_PROC(ID_FILE_QUIT,           file_quit);
  WM_PROC(ID_EDIT_COPY,           edit_copy);
  WM_PROC(ID_EDIT_CUT,            edit_cut);
  WM_PROC(ID_EDIT_PASTE,          edit_paste);
  WM_PROC(ID_EDIT_INSERT_ITEM,    edit_insert_item);
  WM_PROC(ID_EDIT_SELECT_NEXTITEM,edit_select_nextitem);
  WM_PROC(ID_EDIT_SELECT_PREVITEM,edit_select_previtem);
END_WMPROCLIST



MyMainWidget::MyMainWidget( const char* name )
  : KTopLevelWidget( name )
{
  setMinimumSize( 600, 450 );
  setMinimumSize( 500, 350 );

  QPopupMenu *file = new QPopupMenu();
  file->insertItem( klocale->translate("&New project"), ID_FILE_NEW );
  file->insertItem( klocale->translate("&Load project"), ID_FILE_LOAD );
  file->insertItem( klocale->translate("&Save project"), ID_FILE_SAVE );
  file->insertItem( klocale->translate("Save project &as"), ID_FILE_SAVE_AS );
  file->insertSeparator( );
  file->insertItem( klocale->translate("&Quit"), ID_FILE_QUIT );
  CONNECT_WMPROC( file, activated( int ) )

  QPopupMenu *edit = new QPopupMenu();
  edit->insertItem( klocale->translate("&Copy"), ID_EDIT_COPY );
  edit->insertItem( klocale->translate("C&ut"), ID_EDIT_CUT );
  edit->insertItem( klocale->translate("&Paste"), ID_EDIT_PASTE );
  edit->insertSeparator( );
  edit->insertItem( klocale->translate("&Insert new item"), ID_EDIT_INSERT_ITEM );
  edit->insertSeparator( );
  edit->insertItem( klocale->translate("Select &previous item"), ID_EDIT_SELECT_PREVITEM );
  edit->insertItem( klocale->translate("Select &next item"), ID_EDIT_SELECT_NEXTITEM );
  CONNECT_WMPROC( edit, activated( int ) )

  QPopupMenu *help =  kapp->getHelpMenu(true,klocale->translate("kdlgedit-0.1.0\n\n"
                                             "(C) 1999 Pascal Krahmer\n"
                                             "http://www.beast.de\n\n"
                                             "Resource Editor for the K(ool) Desktop Environment"));

  KMenuBar *menu = new KMenuBar( this );
  CHECK_PTR( menu );
 
  menu->insertItem( klocale->translate("&File"), file );
  menu->insertItem( klocale->translate("&Edit"), edit );
  menu->insertItem( klocale->translate("&Help"), help );

  menu->show();
  setMenu( menu );

  KIconLoader *loader = kapp->getIconLoader();

  KToolBar *toolbar1 = new KToolBar( this );
  toolbar1->insertButton( loader->loadIcon( "filenew.xpm" ), ID_FILE_NEW,  TRUE, klocale->translate("Create a new project"));
  toolbar1->insertButton( loader->loadIcon( "fileopen.xpm" ), ID_FILE_LOAD,  TRUE, klocale->translate("Open a project"));
  toolbar1->insertButton( loader->loadIcon( "filefloppy.xpm" ), ID_FILE_SAVE,  TRUE, klocale->translate("Save the project"));
  toolbar1->insertSeparator( );
  toolbar1->insertButton( loader->loadIcon( "editcopy.xpm" ), ID_EDIT_COPY,  TRUE, klocale->translate("Copy"));
  toolbar1->insertButton( loader->loadIcon( "editpaste.xpm" ), ID_EDIT_PASTE,  TRUE, klocale->translate("Paste"));
  toolbar1->insertButton( loader->loadIcon( "editcut.xpm" ), ID_EDIT_CUT, TRUE, klocale->translate("Cut"));
  toolbar1->insertSeparator( );
  toolbar1->insertButton( loader->loadIcon( "pencil.xpm" ), ID_EDIT_INSERT_ITEM,  TRUE, klocale->translate("Insert new item"));
  toolbar1->insertSeparator( );
  toolbar1->insertButton( loader->loadIcon( "previtem.xpm" ), ID_EDIT_SELECT_PREVITEM,  TRUE, klocale->translate("Select previous item from list"));
  toolbar1->insertButton( loader->loadIcon( "nextitem.xpm" ), ID_EDIT_SELECT_NEXTITEM,  TRUE, klocale->translate("Select next item from list"));
  toolbar1->setFullWidth(true);

/*  KToolBar *toolbar2 = new KToolBar( this );
  toolbar2->insertButton( loader->loadIcon( "filenew.xpm" ), ID_EDIT_NEW,  TRUE, klocale->translate("Create new item"));
  toolbar2->insertButton( loader->loadIcon( "filedel.xpm" ), ID_EDIT_DEL,  TRUE, klocale->translate("Remove selected item"));
  toolbar2->insertButton( loader->loadIcon( "configure.xpm" ), ID_EDIT_EDIT,  TRUE, klocale->translate("Edit the items properties"));
//  toolbar2->insertButton( loader->loadIcon( "up.xpm" ), ID_EDIT_UP,  TRUE, klocale->translate("Move source file up into the next destination project"));
//  toolbar2->insertButton( loader->loadIcon( "down.xpm" ), ID_EDIT_DOWN,  TRUE, klocale->translate("Move source file down into the previous destination project"));
  toolbar2->setBarPos( KToolBar::Bottom );
  toolbar2->setFullWidth(false);

  KToolBar *toolbar3 = new KToolBar( this );
  toolbar3->insertButton( loader->loadIcon( "start.xpm" ), ID_BUILD_START,  TRUE, klocale->translate("Start building all changed destination projects"));
  toolbar3->insertButton( loader->loadIcon( "stop.xpm" ), ID_BUILD_STOP,  TRUE, klocale->translate("Stop building"));
  toolbar3->insertButton( loader->loadIcon( "exclamation.xpm" ), ID_BUILD_RUN,  TRUE, klocale->translate("(Build and) Execute selected destination project"));
  toolbar3->insertButton( loader->loadIcon( "exit.xpm" ), ID_BUILD_BREAK,  TRUE, klocale->translate("Kill running destination progress"));
  toolbar3->setBarPos( KToolBar::Bottom );
  toolbar3->setFullWidth(false);
*/
  addToolBar(toolbar1);   toolbar1->show();
//  addToolBar(toolbar3);   toolbar3->show();
//  addToolBar(toolbar2);   toolbar2->show();
  CONNECT_WMPROC( toolbar1, clicked( int ) )
//  CONNECT_WMPROC( toolbar1, doubleClicked( int ) )
//  CONNECT_WMPROC( toolbar2, clicked( int ) )
//  CONNECT_WMPROC( toolbar3, clicked( int ) )


  view = new MyWidget(this);
  setView(view);

  show(); 
}


void MyMainWidget::edit_insert_item()
{
  view->edit->insert_item();
}








