/* vi:set ts=8 sts=0 sw=8:
 *
 * VIM - Vi IMproved		by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * Porting to KDE(2) was done by
 *
 *  (C) 2000 by Thomas Capricelli <orzel@freehackers.org>
 *
 *  Please visit http://freehackers.org/kvim for other vim- or
 *  kde-related coding.
 *
 *  $Id: gui_kde_widget.h,v 1.25 2002/07/29 15:26:03 marchand Exp $
 *
 */

#ifndef GUI_KDE_WIDGET
#define GUI_KDE_WIDGET


#if 1
#define dbf( format, args... ) { printf( "%s" " : " format "\n" , __FUNCTION__ , ## args ); fflush(stdout); }
#define db()       { printf( "%s\n", __FUNCTION__ );fflush(stdout); }
#else
#define dbf(format, args... )
#define db()
#endif
                                                                              


#define UNIX	    // prevent a warning : a symbol is defined twice in X and Qt

#include <qdialog.h>
#include <qlabel.h>
#include <qsignalmapper.h>
#include <qtimer.h>
#include <qmainwindow.h>
#include <qapplication.h>
#include <qevent.h>
#include <qlineedit.h>
#include <qpainter.h>
#include <qframe.h>
#ifndef FEAT_GUI_OPIE
#include <klocale.h>
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <keditcl.h>
#include <kaboutdata.h>
#if (KDE_VERSION>=290)
#include <kmainwindow.h>
#else
#include <ktmainwindow.h>
#endif
#include <kparts/part.h>
#include <kurl.h>
#include "kvim_iface.h"
#endif

#undef UNIX	    // prevent a warning
extern "C" {
#include "vim.h"
}

class QPushButton;
class QDialog;
class QLineEdit;
class QSignalMapper;
class QFrame;
class QPaintEvent;

enum BlinkState {
	BLINK_NONE,
	BLINK_ON,
	BLINK_OFF
};

#ifdef FEAT_GUI_OPIE
// MOC_SKIP_BEGIN
class KVim {
public: 
KVim() { ; }
~KVim() { ;  }

};
// MOC_SKIP_END
#endif

class VimWidget : public QFrame, virtual public KVim
{
	Q_OBJECT

public:
	VimWidget( QWidget *parent=0, const char *name=0, WFlags f=0 );
	virtual void paintEvent( QPaintEvent *);
	void	draw_string(int x, int y, QString s, int len, int flags);

	/** Init the blinking time */
	void set_blink_time( long, long, long );
	void start_cursor_blinking();
	void stop_cursor_blinking();
	void wait(long);
#ifdef FEAT_CLIENTSERVER
	void serverActivate();
#endif
	void flash();
	
	/** DCOP */
	void exec(QString command);
	
	QColor	fg_color;
	QColor	bg_color;
	bool wait_done;
	BlinkState blink_state;
	QPainter *painter;

protected:
	virtual void keyPressEvent( QKeyEvent * );
	virtual void mousePressEvent( QMouseEvent *);
	virtual void mouseDoubleClickEvent( QMouseEvent *);
	virtual void mouseReleaseEvent( QMouseEvent *);
	virtual void mouseMoveEvent( QMouseEvent *);
#ifndef FEAT_GUI_OPIE
	virtual void dragEnterEvent (QDragEnterEvent *);
	virtual void dropEvent (QDropEvent *);
#endif
	virtual void focusInEvent( QFocusEvent * );
	virtual void focusOutEvent( QFocusEvent * );

	/* cursor blinking stuff */
	QTimer blink_timer;
	long blink_wait_time, blink_on_time, blink_off_time;

	/* wait for input */
	QTimer	wait_timer;

public slots:
	void    blink_cursor();
	void	wait_timeout();
};

#ifdef FEAT_GUI_OPIE
#define KMainWindow QMainWindow
#endif

class VimMainWindow : public KMainWindow
{
	Q_OBJECT

public:
	VimMainWindow ( const char *name = 0L, WFlags f = WDestructiveClose );

	/** called when the widget closes */
	bool close(bool alsoDelete);
	VimWidget	*w;
#ifndef FEAT_GUI_OPIE
        KEdFind         *finddlg;
	KEdReplace	*repldlg;
#endif
	int		have_tearoff;

public slots:
	void    menu_activated(int dx);
	void 	clipboard_update();
        void    slotSearch();
        void    slotFind();
        void    slotReplace();
        void    slotReplaceAll();
	void    showAboutApplication();
	void    showTipOfTheDay();
	void    buffersToolbar();

protected:
	virtual void keyPressEvent( QKeyEvent * );
	virtual void wheelEvent (QWheelEvent *);
	virtual void resizeEvent ( QResizeEvent *e );

};


class VimDialog : public QDialog
{
	Q_OBJECT
public:
	VimDialog (int type,		/* type of dialog */
	       unsigned char * title,		/* title of dialog */
	       unsigned char * message,	/* message text */
	       unsigned char * buttons,	/* names of buttons */
	       int def_but,		/* default button */
	       char_u *textfield);		/* input text */
private:
	QSignalMapper	mapper;
	QLineEdit	*entry;
	char_u		*ret;
	int		butNb;

protected slots:
	void done(int);
};


/*
 * QScrollBar  pool
 */
struct GuiScrollbar;

class SBPool : public QObject
{
	Q_OBJECT
public:
	SBPool(void);
	void create(GuiScrollbar * sb, int orient);
	void destroy(GuiScrollbar * sb);
//	QPtrList<GuiScrollbar> sblist;
public slots:
	void sbUsed(int who);
private:
	QSignalMapper mapper;
};

extern VimMainWindow	*vmw;
extern SBPool		*sbpool;


#endif // GUI_KDE_WIDGET
