/*
   This file is part of the KDE project
   Copyright (C) 2004 Martijn Klingens <klingens@kde.org>
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef KCMAUTOSTART_H
#define KCMAUTOSTART_H

#include <qlistview.h>
#include <kcmodule.h>

class KListView;
class QStringList;
class QPushButton;

class AutoStartConfig : public KCModule
{
Q_OBJECT
public:
	AutoStartConfig(QWidget* parent, const char* name= 0L, const QStringList& foo = QStringList());
	~AutoStartConfig() {};

	void       load();
	void       save();
	void       defaults();

	QString quickHelp() const;

protected slots:
	void slotReload();
	void slotItemChecked(QCheckListItem *item);

        bool autoloadEnabled(KConfig *config, const QString &filename);
        void setAutoloadEnabled(KConfig *config, const QString &filename, bool b);

private:
	KListView *_lvStartup;
};

class CheckListItem : public QObject, public QCheckListItem
{
	Q_OBJECT
public:
	CheckListItem(QListView* parent, const QString &text);
	~CheckListItem() { }
signals:
	void changed(QCheckListItem*);
protected:
	virtual void stateChange(bool);
};

#endif // KCMAUTOSTART_H

