/**************************************************************************
*                        kfiledndiconview.h  -  description
*                          -------------------
*  begin                : Wed Nov 1 2000
*  copyright            : (C) 2000 by Bjrn Sahlstrm
*  email                : bjorn@kbear.org
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef KFILEDNDICONVIEW_H
#define KFILEDNDICONVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qdragobject.h>
#include <qtimer.h>
#include <qapplication.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfileiconview.h>
#include <kurldrag.h>

/**
	*This is a fileview inherited from @ref KFileIconView.
	*It adds "drag and drop" suitable for a @ref KFileIconView
  *@author Bjrn Sahlstrm
  */

class KFileDnDIconView : public KFileIconView  {
   Q_OBJECT
public: // Public methods
	/** */
	KFileDnDIconView(QWidget *parent=0, const char *name=0);
	/** */
	~KFileDnDIconView();
	/** Set if Drag'n drop should be enabled or not, default is enabled */
	void setDnDEnabled( bool );
	/**
	*Sets the auto open time, which means the time that will
	*elapse before a directory is automatically opened after entered by DnD.
	*Only need to call this if you want to change the predefined time that is 750 ms.
	*This also calls @ref setAutoOpenTime() so no need to call this to.
	*/
	void setAutoOpenTime( const int& time );
	/**
	*Set this to true if you want the view to use it's auto open functionallity otherwhise set it to false.
	*By default this is turned ON.
	*/
	void useAutoOpenTimer( bool on=true );
	/**
	*@returns true if auto open functionallity is turned ON, otherwhise false
	*@see useAutoOpenTimer
	*@see setAutoOpenTime
	*/
	bool isAutoOpening() const { return b_useAutoOpenTimer; }
signals: // Signals
	/** emitted whenever an decodable item is dropped in the view */
	void dropped( KURL::List );
	/** emitted when the auto open timer times out */
	void openFolder( const QString folderName );
protected slots: // Protected slots
	/** Called when the auto timer times out */
	void slotOpenFolder();
protected: // Protected methods
	/**  */
	virtual void contentsDragEnterEvent( QDragEnterEvent *e );
	/**  */
	virtual void contentsDragMoveEvent( QDragMoveEvent *e );
	/**  */
	virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
	/**  */
	virtual void contentsDropEvent( QDropEvent* e );
	/**
	*Creates a @ref QDragObject containing all urls of the selected @ref KFileViewItem of the view,
	@returns the @ref QDragObject
	*/
	virtual QDragObject* dragObject();
	/**
	*Creates the drag item and starts the drag
	*/
	virtual void startDrag();
private: // Private attributes
	QTimer myAutoOpenTimer;
	int autoOpenTime;
	bool b_useAutoOpenTimer;
	QIconViewItem* dropItem;
};

#endif
