/***************************************************************************
                          kbearquickconnect.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qwhatsthis.h>
#include "kbearquickconnect.h"

//-----------------------------------------------
KBearQuickConnect::KBearQuickConnect(QWidget *parent, const char *name)
		 : KDialog(parent,name,true){
	initDialog();
	PasswordEdit->setEchoMode( QLineEdit::Password );
//	connect( this, SIGNAL(returnPressed()), SLOT(accept()));
	connect(ConnectButton, SIGNAL(clicked()), SLOT(accept()));
	connect(CancelButton, SIGNAL(clicked()), SLOT(reject()));
  QWhatsThis::add(CancelButton,i18n("Press button to cancel and exit dialog"));
  QWhatsThis::add(ConnectButton,i18n("Press button to connect"));
  QWhatsThis::add(RemoteDirEdit,i18n("Enter start directory on remote host here"));
  QWhatsThis::add(PasswordEdit,i18n("Enter your password here"));
  QWhatsThis::add(UserNameEdit,i18n("Enter your user name here\nIf you leave this empty anonymous login is expected!!!"));
  QWhatsThis::add(PortSpinBox,i18n("Select port here"));
  QWhatsThis::add(HostNameEdit,i18n("Enter URL to remote host here"));
}
//-----------------------------------------------
KBearQuickConnect::~KBearQuickConnect(){
}
//-----------------------------------------------
void KBearQuickConnect::accept(){
	close();
	SiteInfo siteInfo;
	siteInfo.info.host = HostNameEdit->text();
	if( siteInfo.info.host == "" )
		return;
	siteInfo.info.port = PortSpinBox->value();
	if( siteInfo.info.port == 0 )
		return;
	siteInfo.info.anonym = AnonymousCheck->isChecked();
	siteInfo.info.user = UserNameEdit->text();
	siteInfo.info.pass = PasswordEdit->text();
	siteInfo.info.path = RemoteDirEdit->text();
	siteInfo.info.label = siteInfo.info.host;
	if( saveSite() ) {
		siteInfo.parent = "Root";
		siteInfo.description = "";
		emit saveToSiteManager( siteInfo );
	}
	emit remoteConnect( siteInfo.info, false );
}
//-----------------------------------------------
void KBearQuickConnect::reject(){
	close();
}
//-----------------------------------------------
