/***************************************************************************
                          sysinfo.h  -  description                              
                             -------------------                                         
    begin                : Wed Jun  9 13:11:44 CEST 1999
                                           
    copyright            : (C) 1999 by Enrico Schulz                         
    email                : emmy@online.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef SYSINFO_H
#define SYSINFO_H
// std headers
#include <syscall.h>
#include <stdio.h>
#include <linux/kernel.h>

// kde headers
#include <kapp.h>
#include <kprogress.h>

// qt headers
#include <qwidget.h>
#include <qtimer.h>
#include <qfile.h>
#include <qlabel.h>
#include <qstring.h>
#include <qpushbutton.h>


class Sysinfo : public QWidget {
  Q_OBJECT 
public: 
  /** construtor */
  Sysinfo(QWidget*parent=0,const char* name=0); 
  /** destructor */
  ~Sysinfo();

public slots:
  void updateall();
  void infoclicked();
  void exitthis();

private:
  void initializewindow();

  void getmeminfo();
  QString format(unsigned long value);

private:
  struct sysinfo info;
  QTimer *timer;
  QLabel *totalram;
  QLabel *freeram;
  QLabel *swapram;
  QLabel *freeswapram;
  QLabel *bufferedram;
  QLabel *sharedram;
  QLabel *procs;
  QPushButton *infobutton;
  QPushButton *quitbutton;

  KProgress *ramprogress;
  KProgress *swapprogress;
  void resizeEvent(QResizeEvent *)
  {
    this->resize(345, 150);
  }
};
#endif


