/***************************************************************************
                          lostview.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Jun  5 13:37:40 CEST 1999
                                           
    copyright            : (C) 1999 by jec                         
    email                : cuendet@linkvest.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "lostview.h"
#include "lost.h"
#include "lost_dirchooserdialog.h"

#include <rpm/rpmlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>

#include <qmessagebox.h>
#include <qfileinfo.h>
#include <qdir.h>

#include <list>

#include <time.h>




	
	
	
	
LoSTView::LoSTView(LoSTApp* parent)
	:QListView(parent),
	parent_(parent),
	basePath_(),
	mustStop_(false),
	isUpdating_(false),
	isUpdated_(false),
	root_(0),
	sortOption_(SIZE),
	viewOption_(REAL_SIZE),
	asc_(true)
{

	setMultiSelection(false);
	setRootIsDecorated(true);
	setTreeStepSize(12);
	setUpdatesEnabled(true);
	setSorting(0, true);
	
	int nameColIndex = addColumn("Name");
	setColumnWidthMode(nameColIndex, QListView::Manual);
	setColumnWidth(0, size().width());
	
	QString str("<Choose a directory to begin!>");
	root_ = new LoST_TreeNode(*this, str, LoST_TreeNode::UNKNOWN);
	
	closeDirPixmap_ = Icon("mini/folder.xpm");
	openDirPixmap_ = Icon("mini/folder_open.xpm");
	filesPixmap_ = Icon("editcopy.xpm");
	filePixmap_ = Icon("filenew.xpm");
	symLinkPixmap_ = Icon("mini/mini-lower.xpm");
	unknownPixmap_ = Icon("help.xpm");
}

LoSTView::~LoSTView()
{
}

void LoSTView::setExcludeDirList(StdStringList& list)
{
	excludeDirList_.clear();
	StdStringListIterator iter(list);
	std::string* str = iter.first();
	while(str)
	{
		excludeDirList_.insert(excludeDirList_.end(), *str);
		str = iter.next();
	}
}

StdStringList& LoSTView::getExcludeDirList()
{
	return excludeDirList_;
}

LoSTView::e_SortOptions LoSTView::getSortOption() const
{
	return sortOption_;
}
void LoSTView::setSortOption(LoSTView::e_SortOptions o)
{
	asc_ = !asc_;
	sortOption_ = o;
	root_->sortChildItems(0, asc_);
	updateView();
}

LoSTView::e_ViewOptions LoSTView::getViewOption() const
{
	return viewOption_;
}
void LoSTView::setViewOption(LoSTView::e_ViewOptions o)
{
	viewOption_ = o;
	setNeedSizeUpdateToAll(root_);
	updateView();
}
	
void LoSTView::setColumnWidth(int column, int w)
{
	if (column == 0)
	{
		QSize s = size();
		w = s.width();
	}
	QListView::setColumnWidth(column, w);
}

const QPixmap* LoSTView::getPixmap(LoST_TreeNode::e_Type type, int param)
{
	QPixmap* p = 0;
	switch(type)
	{
	case LoST_TreeNode::SKIPPED:
		p = &closeDirPixmap_;
		break;
	case LoST_TreeNode::DIR:
		if (param == 1) // open
		{
			p = &openDirPixmap_;
		}
		else
		{
			p = &closeDirPixmap_;
		}
		break;
	case LoST_TreeNode::FILES:
		p = &filesPixmap_;
		break;
	case LoST_TreeNode::FILE:
		p = &filePixmap_;
		break;
	case LoST_TreeNode::SYM_LINK:
		p = &symLinkPixmap_;
		break;
	case LoST_TreeNode::UNKNOWN:
	default:
		p = &unknownPixmap_;
		break;
	};
	return p;
}

void LoSTView::updateTree()
{
	updateTree(basePath_);
}

void LoSTView::stopUpdate()
{
	mustStop_ = true;
}

void LoSTView::updateTree(const QString& base)
{
	QString temp;
	if (base == "")
	{
		temp = "The root dir is not correct <";
		temp += base;
		temp += ">";
		KMsgBox::message(this, "", temp);
		return;
	}
	
	if (isUpdating_)
	{
		temp = "Already updating. Stop before doing so.";
		KMsgBox::message(this, "", temp);
		return;
	}
	
	parent_->beginUpdating();
	
	basePath_ = base;
	isUpdating_ = true;
	mustStop_ = false;
	
	if (basePath_[basePath_.length()-1] == '/' && basePath_.length() > 1)
	{
		basePath_.truncate(basePath_.length()-1);
	}
	
	// Init
	QFileInfo i( basePath_ );
	if (i.isDir())
	{
		delete root_;
		root_ = new LoST_TreeNode(*this, basePath_, LoST_TreeNode::DIR);
		root_->setOpen(true);
		fillNode(root_);
	}
	else
	{
		QString str;
		str = "The choosen PATH '";
		str += basePath_;
		str += "' is NOT a directory!";
		KMsgBox::message(this, "", str);
	}
	
	parent_->stopUpdating();
	
	isUpdated_ = true;
	isUpdating_ = false;
	mustStop_ = false;
}
	
void LoSTView::excludeDirs()
{
	LoST_DirChooserDialog dlg;
	dlg.setExcludeDirs(excludeDirList_);
	int ret = dlg.exec();
	if (ret)
	{
		excludeDirList_.clear();
		dlg.getExcludeDirs(excludeDirList_);
	}
}

void LoSTView::updateView()
{
	// Oh, the pretty HACK.... Don't know how to do better
	LoST_TreeNode* tempNode = new LoST_TreeNode(root_, *this, QString("Temp_To_Delete"), LoST_TreeNode::FILE);
	root_->removeItem(tempNode);
}
	
void LoSTView::diffWithRpms()
{
	if (isUpdating_)
	{
		KMsgBox::message(this, "", i18n("Can't DIFF while updating. Wait or stop.") );
		return;
	}
	
	if (!isUpdated_)
	{
		KMsgBox::message(this, "", i18n("You can't DIFF now. Update the tree first.") );
		return;
	}
	
	isUpdating_ = true;
	mustStop_ = false;
	parent_->beginUpdating();
	
	std::list<std::string> filesList;
	QString str, temp;
	int ret = 0;
	ret = getListOfInstalledFiles(filesList, str);
	if (ret == 1)
	{
		// BEGIN TEMP
		/*
		filesList.clear();
		std::string astr;
		astr = "/home/lost_test/ok/ash0";
		filesList.insert(filesList.end(), astr);
		astr = "/home/lost_test/ok/b1/a2";
		filesList.insert(filesList.end(), astr);
		astr = "/home/lost_test/ok/b1/a2/ash_a2";
		filesList.insert(filesList.end(), astr);
		astr = "/home/lost_test/ok/a1/ash1";
		filesList.insert(filesList.end(), astr);
		astr = "/home/lost_test/ok/b1/b2";
		filesList.insert(filesList.end(), astr);
		astr = "/home/lost_test/ok/a1";
		filesList.insert(filesList.end(), astr);
		*/
		// END TEMP
		
		filesList.sort();
		filesList.reverse();
	
		std::list<std::string>::iterator first = filesList.begin();
		std::list<std::string>::iterator last = filesList.end();
		int nb = 0;
		while (first != last)
		{
			std::list<std::string>::iterator next = first;
			++next;
			
			const std::string& str = *first;
			QString fileName;
			copyStdStringToQString(fileName, str);
			
			temp = "Filename (from list) :";
			temp += fileName;
			//KMsgBox::message(this, "", temp);
			
			nb++;
			if (nb % 1000 == 0)
			{
				temp = "Processing file: ";
				temp += fileName;
				parent_->slotStatusMsg(temp);
				KApplication::getKApplication()->processEvents(-1);
				if (mustStop_)
				{
					break;
				}
			}
			
			removePath(fileName);
			
			first = next;
		}
	}
	else
	{
		if (ret == -1)
		{
			temp = "RPM ERROR:\n<" + str + ">";
			KMsgBox::message(this, "", temp);
		}
		// ret == 0 -> normal stop from user
	}
	
	filesList.clear();
	
	isUpdating_ = false;
	mustStop_ = true;
	parent_->stopUpdating();
	
	updateView();
	//KMsgBox::message(this, "", i18n("That's all OK. DIFF done") );
	
	parent_->slotStatusMsg(IDS_DEFAULT);
	
	return;
}

void LoSTView::removePath(const QString& str)
{
	QString temp;
	QString fileName = str;
	QString origFileName = str;
	temp = "Filename: " + fileName;
	//KMsgBox::message(this, "", temp);
	
	const QString& rootPath = root_->getCompletePath();
	temp = "Root: " + rootPath;
	//KMsgBox::message(this, "", temp);
	
	// Find the ROOT at the beginning of the file name
	if (0 != fileName.find(rootPath, 0))
	{
		temp = "Skipped: " + fileName;
		//KMsgBox::message(this, "", temp);
		// Not OK
		return;
	}
	
	temp = "Filename to remove: ";
	temp += fileName;
	//KMsgBox::message(this, "", temp);

	// Got only the part after ROOT	
	fileName.remove(0, rootPath.length()+1);
	temp = "After removing root: <" + fileName + ">";
	//KMsgBox::message(this, "", temp);
	
	if (fileName.length() == 0)
	{
		return;
	}
	
	QString part;
	
	// Try to find a node that match
	LoST_TreeNode* currentNode = root_;
	
	while(currentNode != 0)
	{
		int pos = fileName.find('/');
		if (pos == -1)
		{
			// '/' not found -> file
			temp = "Filename to search: " + fileName;
			//KMsgBox::message(this, "", temp);
			
			LoST_TreeNode* found = currentNode->getFileThatMatch(fileName);
			if (found != 0)
			{
				temp = "Removed(file): ";
				temp += origFileName;
				//KMsgBox::message(this, "", temp);
				currentNode->removeFile(found);
				return;
			}
			found = currentNode->getChildThatMatch(fileName);
			if (found != 0)
			{
				temp = "Removed(Dir): ";
				temp += origFileName;
				//KMsgBox::message(this, "", temp);
				currentNode->removeDir(found);
				return;
			}
			temp = "The filename <";
			temp += fileName;
			temp += "> is not found";
			//KMsgBox::message(this, "", temp);
			return;
		}
		else
		{
			temp = fileName.left(pos);
			fileName.remove(0, pos+1);
			currentNode = currentNode->getChildThatMatch(temp);
			
			if (currentNode == 0)
			{
				temp = "Left part (not found): <" + temp + ">";
			}
			else
			{
				temp = "Left part (found): <" + temp + ">";
			}
			//KMsgBox::message(this, "", temp);
		}
	} // end while
}

void LoSTView::diffWithDebs()
{
	KMsgBox::message(this, "", "Not implemented yet!");
}

bool LoSTView::fillNode(LoST_TreeNode* currentNode)
{
	ASSERT(currentNode);
	
	KApplication::getKApplication()->processEvents(-1);
	if (mustStop_)
	{
		return false;
	}
	
	// Check exclude dir list
	StdStringListIterator iter(excludeDirList_);
	std::string *str = iter.first();
	while(str)
	{
		QString qstr;
		copyStdStringToQString(qstr, *str);
		if ( qstr == currentNode->getCompletePath() )
		{
			currentNode->setType(LoST_TreeNode::SKIPPED);
			return true;
		}
		str = iter.next();
	}
	
	LoST_TreeNode* filesNode = new LoST_TreeNode(currentNode, *this, QString("Files"), LoST_TreeNode::FILES);
	currentNode->setFilesNode(filesNode);
	
	QDir dir( currentNode->getCompletePath() );
	
	parent_->slotStatusMsg( QString(dir.canonicalPath()) );
	
	dir.setMatchAllDirs(true);
	QFileInfoList* list = (QFileInfoList*)dir.entryInfoList();
	if (list == 0)
	{
		QString temp;
		temp.sprintf("The list could not be found for dir <%s>", dir.path());
		KMsgBox::message(this, "", temp);
		return false;
	}
	
	// First the files
	for (int i=0;i<(int)list->count();i++)
	{
		const QFileInfo* e = list->at(i);
		ASSERT(e);
		if ( e->isFile() )
		{
			LoST_TreeNode* node = 0;
			if (e->isSymLink())
			{
				node = new LoST_TreeNode(filesNode, *this, e->fileName(), LoST_TreeNode::SYM_LINK );
				node->setSymbolicLink(e->readLink());
			}
			else
			{
				node = new LoST_TreeNode(filesNode, *this, e->fileName(), LoST_TreeNode::FILE );
			}
			node->setSize( e->size() );
		}
	}
	
	// Then the directories
	for (int i=0;i<(int)list->count();i++)
	{
		const QFileInfo* e = list->at(i);
		ASSERT(e);
		if (	e->isDir() &&
			!e->isSymLink() &&
			e->fileName() != ".." &&
			e->fileName() != "." )
		{
			LoST_TreeNode* node = new LoST_TreeNode(currentNode, *this, e->fileName(), LoST_TreeNode::DIR );
			
			currentNode->removeItem( node );
			currentNode->insertItem( node );
			
			if (!fillNode(node))
			{
				return false;
			}
			node->setNeedSizeUpdateRecurse();
		}
	}
	
	filesNode->setNeedSizeUpdateRecurse();
	currentNode->sortChildItems(0, true);
	return true;
}

void LoSTView::setNeedSizeUpdateToAll(LoST_TreeNode* node)
{
	node->setNeedSizeUpdate(true);
	LoST_TreeNode* child = (LoST_TreeNode*)node->firstChild();
	while(child)
	{
		setNeedSizeUpdateToAll(child);
		child = (LoST_TreeNode*)child->nextSibling();
	}
}

void LoSTView::slotRightButtonPressed(QListViewItem* qitem, const QPoint& p, int i)
{
	LoST_TreeNode* item = (LoST_TreeNode*)qitem;
	
	QPopupMenu menu(0);
	switch(item->getType())
	{
	case LoST_TreeNode::DIR:
		menu.insertItem(Icon("kexplorer.xpm"), i18n("&Explore"), ID_POPUP_EXPLORE );
		menu.insertSeparator();
		menu.insertItem(Icon("filedel.xpm"), i18n("&Delete"), ID_POPUP_DELETE );
		menu.insertSeparator();
		menu.insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_POPUP_COPY );
		menu.insertItem(Icon("editcut.xpm"), i18n("C&ut"), ID_POPUP_CUT );
		menu.insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_POPUP_PASTE );
		break;
		
	case LoST_TreeNode::SKIPPED:
		return;
	
	case LoST_TreeNode::FILES:
		menu.insertItem(Icon("filedel.xpm"), i18n("&Delete"), ID_POPUP_DELETE );
		break;
		
	case LoST_TreeNode::SYM_LINK:
	case LoST_TreeNode::FILE:
		menu.insertItem(Icon("openbook.xpm"), i18n("&Open"), ID_POPUP_OPEN );
		menu.insertSeparator();
		menu.insertItem(Icon("filedel.xpm"), i18n("&Delete"), ID_POPUP_DELETE );
		menu.insertSeparator();
		menu.insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_POPUP_COPY );
		menu.insertItem(Icon("editcut.xpm"), i18n("C&ut"), ID_POPUP_CUT );
		menu.insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_POPUP_PASTE );
		break;
		
	default:
		KMsgBox::message(this, "", "This item type is not known");
		break;
	};
	int id = menu.exec(p);
	
	treatPopupMenu(id, (LoST_TreeNode*)item);
}

void LoSTView::treatPopupMenu(int id, LoST_TreeNode* item)
{
	QString command;
	QString param;
	switch(id)
	{
	case ID_POPUP_EXPLORE:
		{
			command = "kfm ";
			command += item->getCompletePath();
			if ( -1 == system(command) )
			{
				KMsgBox::message(this, "", "Can't start command");
			}
		}
		break;
	case ID_POPUP_OPEN:
		{
			command = "kedit ";
			command += item->getCompletePath();
			if ( -1 == system(command) )
			{
				KMsgBox::message(this, "", "Can't start command");
			}
		}
		break;
	case ID_POPUP_DELETE:
		{
			QString str;
			str = "Are you sure you want to delete ";
			str += item->getCompletePath();
			if (1 == KMsgBox::yesNo(this, "", str))
			{
				command = item->getCompletePath();
				if (QFile::remove(command))
				{
					str = item->getCompletePath();
					str += " was NOT removed from DISK";
					KMsgBox::message(this, "", str);
				}
			}
		}
		break;
	case ID_POPUP_COPY:
	case ID_POPUP_CUT:
	case ID_POPUP_PASTE:
			KMsgBox::message(this, "", "Not yet implemented.");
		break;
	};
}

void LoSTView::resizeEvent(QResizeEvent* e)
{
	QListView::resizeEvent(e);
	setColumnWidth(0, e->size().width() );
}

int LoSTView::getListOfInstalledFiles(StdStringList& filesList, QString& errorString)
{
	return getListOfInstalledFiles_RPM(filesList, errorString);
#ifdef HAVE_RPM
#else
 #ifdef HAVE_DEB
	return getListOfInstalledFiles_DEB(filesList, errorString);
 #endif
#endif
	errorString = "No package manager was compiled in!\nModify the Makefile before compiling";
	return -1;
}

int LoSTView::getListOfInstalledFiles_RPM(std::list<std::string>& filesList, QString& errorString)
{
    int error;
    rpmdb db = 0;
    QString str, temp;
    QString packageName;

    rpmReadConfigFiles(NULL, NULL, NULL, 0);

    error = rpmdbOpen("", &db, O_RDONLY, 0644);
    if (error != 0)
    {
        errorString = rpmErrorString();
        return -1;
    }
	
    unsigned int offset = rpmdbFirstRecNum(db);
    if (offset == 0)
    {
        errorString = rpmErrorString();
        return -1;
    }

	int_32 type;
    int_32 size;
    void* p = 0;
    while(offset != 0)
    {
        Header header = rpmdbGetRecord(db, offset);
        if (header == 0)
        {
			KMsgBox::message(this, "", "rpmdbGetRecord");
            errorString = rpmErrorString();
            return -1;
        }

        // Get the name
		p = 0;
        error = headerGetEntry(header, RPMTAG_NAME, &type, &p, &size);
        if (error == 0)
        {
        	str = packageName + " : headerGetEntry1";
			KMsgBox::message(this, "", str);
            errorString = rpmErrorString();
            return -1;
        }
        packageName = (char*)p;
		temp = "Processing package: ";
		temp += packageName;
		parent_->slotStatusMsg(temp);
		KApplication::getKApplication()->processEvents(-1);
		if (mustStop_)
		{
			return 0; // Stop fomr user
		}
		
        // Get the filenames
		p = 0;
        error = headerGetEntry(header, RPMTAG_FILENAMES, &type, &p, &size);
        if (error != 0)
        {
        	// Contains files
	        if (size > 0)
    	    {
        	    char** fileNames = (char**)p;
            	for (int i=0;i<size;i++)
	            {
    	            str = fileNames[i];
        	        filesList.insert(filesList.end(), std::string(str));
            	}
            }
        }
        else
        {
        	// No files...
        }

        offset = rpmdbNextRecNum(db, offset);
    }

    rpmdbClose(db);
    return 1;
}




















































































