/***************************************************************************
                          lost.h  -  description                              
                             -------------------                                         
    begin                : Sat Jun  5 13:37:40 CEST 1999
                                           
    copyright            : (C) 1999 by jec                         
    email                : cuendet@linkvest.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LOST_H
#define LOST_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

// application specific includes
#include "lostview.h"
#include "resource.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class LoSTView is
  * created which creates your view.
  */
class LoSTApp : public KTMainWindow
{
  Q_OBJECT

public:
  /** construtor */
  LoSTApp(); 
  /** destructor */
  ~LoSTApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);

  void beginUpdating();
  void stopUpdating();

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** open a new application window */
  void slotFileNewWindow();
  void slotFileChooseDir();
  void slotFileUpdate();
  void slotFileStopUpdate();
  /** close the current window */
  void slotFileCloseWindow();
  /** exits the application */
  void slotFileQuit();
  /** put the marked text/object into the clipboard and remove
    *	it from the document */
  void slotEditCut();
  /** put the marked text/object into the clipboard*/
  void slotEditCopy();
  /** paste the clipboard into the document*/
  void slotEditPaste();
  /** toggle the toolbar*/
  void slotShowToolBar();
  /** toggle the statusbar*/
  void slotShowStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
	
	void slotSortName();
	void slotSortSize();
	void slotViewRealSize();
	void slotViewUsedSize();
	void slotViewPercent();

protected:
	virtual void closeEvent(QCloseEvent* e);
	bool queryExit(bool askForQuit);

private:
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu* fileMenu_;
  QPopupMenu* viewMenu_;
  QPopupMenu* actionsMenu_;
  QPopupMenu* helpMenu_;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
	LoSTView *view_;
	StdStringList excludeDirList_;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  bool viewToolbar_;
  bool viewStatusbar_;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menubarPos_;
  KToolBar::BarPosition toolbarPos_;
};
 
#endif // LOST_H










