#include <kwin.h>
#include <kwin.moc>

#include <qpushbt.h>

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <string.h>
#include <qstring.h>

KWin::KWin(QWidget *parent, const char *name)
	: KTopLevelWidget(name)
{
	QLabel *label;
	QPushButton *button;
	QString p;
	char *text,hst[1024];

	QPopupMenu *file_menu = new QPopupMenu();
	file_menu->insertItem(i18n("E&xit"), kapp, SLOT(quit()));

	QPopupMenu *help_menu = new QPopupMenu();
	help_menu->insertItem(i18n("&Help"), this, SLOT(invokeHelp()));


	resize(730,340);
	setMinimumSize(730,340);
	setMaximumSize(730,340);
	menuBar = new KMenuBar(this, "menubar");
	menuBar->insertItem(i18n("&File"), file_menu);
	menuBar->insertItem(i18n("&Help"), help_menu);

	setMenu(menuBar);

	toolBar = new KToolBar(this);
	addToolBar(toolBar);

	statusBar = new KStatusBar(this);
	setStatusBar(statusBar);

	view = new KWinWidget(this);
	setView(view);

	printer = new QPixmap("/opt/kde/share/apps/kwin/pics/printer.xpm");
	disk = new QPixmap("/opt/kde/share/apps/kwin/pics/mini-filemgr.xpm");
	computer = new QPixmap("/opt/kde/share/apps/kwin/pics/mini-display.xpm");

	treeList = new KTreeList(view,"Resource Browser");
	treeList->move(10,13);
	treeList->setAutoUpdate(TRUE);
	treeList->setScrollBar(TRUE);
	treeList->resize(200,250);
	
	mountList = new KTabListBox(view,0,2);
	mountList->move(400,10);
	mountList->resize(320,250);
	mountList->setAutoUpdate(TRUE);
	mountList->setSeparator ('|');
	mountList->setColumn(0,"Resource",150);
	mountList->setColumn(1,"MountPoint",150);
	
	label = new QLabel("Resources Browser",view);
	label->move(10,0);
	label->resize(150,10);

	button = new QPushButton(view);
	button->setText("Browse Computer");
	button->move(220,80);
	button->resize(150,25);
	connect(button,SIGNAL(clicked()),SLOT(start()));

	button = new QPushButton(view);
	button->setText("Remove Item");
	button->move(220,110);
	button->resize(150,25);
	connect(button,SIGNAL(clicked()),SLOT(removeitem()));

	button = new QPushButton(view);
	button->setText("Mount Resource");
	button->move(220,140);
	button->resize(150,25);
	connect(button,SIGNAL(clicked()),SLOT(mpress()));

	button = new QPushButton(view);
	button->setText("Umount Resource");
	button->move(220,170);
	button->resize(150,25);
	connect(button,SIGNAL(clicked()),SLOT(upress()));

	button = new QPushButton(view);
	button->setText("Open Folder");
	button->move(220,200);
	button->resize(150,25);
	connect(button,SIGNAL(clicked()),SLOT(opress()));

	host = new KLined(view,"host");
	host->move(220,25);
	host->resize(150,20);
	label = new QLabel("Host Name",view);
	label->move(220,10);
	label->setAutoResize(TRUE);

	UpdateMountList();
}

KWin::~KWin()
{
	delete toolBar;
	delete statusBar;
	delete menuBar;
	delete treeList;
}

void KWin::invokeHelp()
{
	kapp->invokeHTMLHelp("kwin/kwin.html", "");
}

void KWin::Browse(char *server,char *ip)
{
	KProcess *p;

	p=new KProcess();
	p->setExecutable("/usr/sbin/smbclient");
	p->clearArguments();
	(*p) << "/usr/sbin/smbclient";
	(*p) << "-U";
	(*p) << "nobody";
	(*p) << "-L";
	(*p) << server;
	
	treeList->insertItem(server,computer,0);
	
	connect(p,SIGNAL(receivedStdout(KProcess *,char *,int)), SLOT(addResources(KProcess *, char *,int)));
	p->start(KProcess::Block, KProcess::Stdout);
	delete p;
}

void KWin::addResources(KProcess *p, char * buffer, int len)
{
	char name[1024], tmp[1024],*p1,*p2,*p3;
	memset(name,0,1024);
	memset(tmp,0,1024);

	p1=p2=buffer;
	while (p2-buffer<len && (p1=strchr(p2,'\n'))!=0) {
		memset(tmp,0,1024);
		strncpy(tmp,p2,p1-p2);
		
		if (strstr(tmp,"Disk")!=0) {
			p3=tmp;
			strncpy(name,tmp,strstr(p3,"Disk")-p3);
			p3=name+strlen(name);
			while (*p3=='\0' || *p3==' ' || *p3=='\t') p3--;
			p3++;
			*p3='\0';
			p3=name;
			while (*p3==' ' || *p3=='\t') p3++;
			if (strstr(p3,"WPS")==0 && p3[strlen(p3)-1]!='$')
				treeList->addChildItem(p3,disk,0);
		} 
		if (strstr(tmp,"Printer")!=0) {
			p3=tmp;
			strncpy(name,tmp,strstr(p3,"Printer")-p3);
			p3=name+strlen(name);
			while (*p3=='\0' || *p3==' ' || *p3=='\t') p3--;
			p3++;
			*p3='\0';
			p3=name;
			while (*p3==' ' || *p3=='\t') p3++;
			if (strstr(p3,"WPS")==0 && p3[strlen(p3)-1]!='$')
				treeList->addChildItem(p3,printer,0);
		} 
		p2=p1+1;
	}
}

void KWin::start()
{
	if (strlen(host->text())>0) {
		Browse((char *)host->text(), NULL);
	} 
}

void KWin::removeitem()
{
	if (treeList->currentItem()!=-1)
		treeList->removeItem(treeList->currentItem());
}

void KWin::UpdateMountList()
{
	FILE *f;
	char *p1,*p2,*p3,*q1,*q2;
	char buff[1024],tmp[1024],tmp1[1024];        
	
	while (mountList->count()>0) mountList->removeItem(0);

	f=fopen("/etc/mtab","r");
	
	if (f<=0) return;
	 while(read(fileno(f),buff,1024)>0)
	{
		q1=q2=buff;
		while (q2-buff<strlen(buff) && (q1=strchr(q2,'\n'))!=0) {
			memset(tmp,0,1024);
			strncpy(tmp,q2,q1-q2);
			if ((p1=strstr(tmp,"smbfs"))!=0) {
				p2=p1-1;
				while(*p2==' ' || *p2=='\t') p2--;
				p2++; *p2='\0'; p2--;
				while(*p2!=' ' && *p2!='\t') p2--;
				p3=p2;
				p2++;
				while(*p3==' ' || *p3=='\t') p3--;
				p3++; *p3='\0'; p3--;
				sprintf(tmp1,"%s|%s",tmp,p2);
				mountList->insertItem(tmp1);
			}
			q2=q1+1;
		}
	}
	fclose(f);
}

void KWin::mpress()
{
	KMsgBox * m;
	char *hd,*server,mount[1024];
	KTreeListItem *it,*pa;
	KMount *nw;
	
	it=treeList->getCurrentItem();
	if (it==NULL) return;
	hd=it->getText();
	pa=it->getParent();
	if (pa==NULL) return;
	server=pa->getText();
	
	sprintf(mount,"\"//%s/%s\"",server,hd);
	
	nw= new KMount(0,"mount",mount,this);
}


void KWin::upress()
{
	KProcess *p;
	QString s;
	char tmp[1024];

	if (mountList->currentItem()<0) return;
	s=mountList->text(mountList->currentItem(),1);
	if (s.length<=0) return;
	
	p=new KProcess();
	p->clearArguments();
	(*p) << "kvt";
	(*p) << "-e";
	(*p) << "su";
	(*p) << "-c";
	
	sprintf(tmp,"/usr/sbin/smbumount %s",(const char *)s);
	(*p) << tmp;
	
	
	p->start(KProcess::Block, KProcess::NoCommunication);
	delete p;
	UpdateMountList();
	
}

void KWin::opress()
{
	KProcess *p;
	QString s;
	
	if (mountList->currentItem()<0) return;
	s=mountList->text(mountList->currentItem(),1);
	if (s.length<=0) return;
	

	p=new KProcess();
	p->clearArguments();
	(*p) << "kfmclient";
	(*p) << "openURL";
	(*p) << (const char *)s;
	p->start(KProcess::DontCare, KProcess::NoCommunication);
	delete p;
}
/* KMOUNT OBJECT */

KMount::KMount(QWidget *parent, const char *name,const char *res,KWin *pa)
	: KTopLevelWidget(name)
{
	QLabel *label;
	QPushButton *button;
	char tmp[1024];
	
	kwin=pa;
	if (res==0) return;
	resize(270,247);
	setMinimumSize(270,247);
	setMaximumSize(500,247);
	
	view = new KWinWidget(this);
	setView(view);

	sprintf(tmp,"Resource to mount: %s",res);
	strcpy(resource,res);

	status = new QLabel(tmp,view);
	status->move(2,230);
	status->resize(240,20);

	label = new QLabel(tmp,view);
	label->move(10,10);
	label->setAutoResize(TRUE);


	label = new QLabel("Mount Point",view);
	label->move(10,40);
	label->setAutoResize(TRUE);

	label = new QLabel("UID",view);
	label->move(10,70);
	label->setAutoResize(TRUE);

	label = new QLabel("GID",view);
	label->move(130,70);
	label->setAutoResize(TRUE);

	label = new QLabel("File Mode",view);
	label->move(10,100);
	label->setAutoResize(TRUE);

	label = new QLabel("Dir Mode",view);
	label->move(130,100);
	label->setAutoResize(TRUE);

	label = new QLabel("Password",view);
	label->move(10,130);
	label->setAutoResize(TRUE);
	
	mpoint = new KLined(view,"mpoint");
	mpoint->move(80,40);
	mpoint->resize(110,20);
	mpoint->setText("/mnt/");
	
	uid = new KLined(view,"uid");
	uid->move(80,70);
	uid->resize(50,20);
	uid->setText("0");
	
	gid = new KLined(view,"gid");
	gid->move(180,70);
	gid->resize(50,20);
	gid->setText("0");

	mode1 = new KLined(view,"mode1");
	mode1->move(80,100);
	mode1->resize(30,20);
	mode1->setText("755");
	
	mode2 = new KLined(view,"mode2");
	mode2->move(200,100);
	mode2->resize(30,20);
	mode2->setText("755");

	pwd = new KLined(view,"pwd");
	pwd->move(80,130);
	pwd->resize(150,20);
	pwd->setEchoMode(QLineEdit::Password);
	
	button = new QPushButton(view);
	button->setText("Mount");
	button->move(10,180);
	button->setAutoResize(TRUE);
	connect(button,SIGNAL(clicked()),SLOT(mpress()));

	button = new QPushButton(view);
	button->setText("Cancel");
	button->move(80,180);
	button->setAutoResize(TRUE);
	connect(button,SIGNAL(clicked()),SLOT(cpress()));

	button = new QPushButton(view);
	button->setText("Browse");
	button->move(200,40);
	button->setAutoResize(TRUE);
	connect(button,SIGNAL(clicked()),SLOT(bpress()));

	show();
}

KMount::~KMount()
{
	delete mpoint;
	delete uid;
	delete gid;
	delete mode1;
	delete mode2;
	delete pwd;
	delete status;
}

void KMount::cpress()
{
	delete this;
}

void KMount::mpress()
{
	KProcess *p;
	KMsgBox *m;
	char tmp[1024];

	if (strlen(mpoint->text())<=0 || strcmp(mpoint->text(),"/")==0) {
		m= new KMsgBox(view,"ERROR","Invalid Mount Point",KMsgBox::EXCLAMATION,"OK");
		m->show();
		delete m;
		return;
	}

	if (atoi(uid->text())<0 || atoi(gid->text())<0) {
		m= new KMsgBox(view,"ERROR","Invalid UID/GID (<0)",KMsgBox::EXCLAMATION,"OK");
		m->show();
		delete m;
		return;
	}

	if (strlen(mode1->text())!=3 || strlen(mode2->text())!=3) {
		m= new KMsgBox(view,"ERROR","Invalid File/Dir MODE, Use OCTAL Notation",KMsgBox::EXCLAMATION,"OK");
		m->show();
		delete m;
		return;
	}

	p=new KProcess();
	p->clearArguments();
	(*p) << "kvt";
	(*p) << "-e";
	(*p) << "su";
	(*p) << "-c";
	sprintf(tmp,"/usr/sbin/smbmount %s %s -u %s -g %s -f %s -d %s",
		resource,mpoint->text(),uid->text(),gid->text(),mode1->text(),mode2->text());
	if (strlen(pwd->text())>0) {
		sprintf(tmp,"%s -P %s",tmp,pwd->text());
	} else {
		sprintf(tmp,"%s -n",tmp);
	}
	(*p) << tmp;
	p->start(KProcess::Block, KProcess::NoCommunication);
	kwin->UpdateMountList();
	delete p;
	p=new KProcess();
	p->clearArguments();
	(*p) << "kfmclient";
	(*p) << "openURL";
	(*p) << mpoint->text();
	p->start(KProcess::DontCare, KProcess::NoCommunication);
	delete p;
	delete this;
}

void KMount::pstdout(KProcess *p, char * buffer, int len)
{
	KMsgBox *m;
	
	status->setText(buffer);
	m=new KMsgBox(0,"SMB OUTPUT",buffer,KMsgBox::INFORMATION,"OK");
	m->setGeometry(10,10,400,200);
	m->show();
	delete m;
}

void KMount::pexit(class KProcess *p)
{
	KMsgBox *m;
	kwin->UpdateMountList();
	
	delete p;
	
	delete this;
}

void KMount::bpress()
{
	KDirDialog *b;
	QString dir;
	
	b= new KDirDialog("",0,0);
	dir=b->getDirectory("file:/mnt",0,0);
	mpoint->setText((const char *)dir);
}
