// ----------------------------------------------------------------------------
// File:    ItemDialogData.h
// $Date: 1999/06/10 16:11:11 $
// $Revision: 1.2 $
// ----------------------------------------------------------------------------

#ifndef ItemDialogData_included
#define ItemDialogData_included

#include <qdialog.h>
#include <qlined.h>
#include <qspinbox.h>

/**
 * New/Edit project/sub-project/task dialog data class.
 *
 * Base class for the new/edit dialog.  This class is responsible for creating
 * the dialog itself, and for holding all of the data items.  All of the
 * functionality provided by the class is implemented in @ref ItemDialog.
 *
 * @author  Graham TerMarsch (gtermars@home.com)
 * @version $Revision: 1.2 $
 * @see     ItemDialog 
 */
class ItemDialogData : public QDialog
{
    Q_OBJECT

public:
    /**
     * Constructor.
     *
     * @param   parent  Parent widget
     * @param   name    Name of this widget
     */
    ItemDialogData( QWidget* parent = NULL, const char* name = NULL );

    /**
     * Destructor
     */
    virtual ~ItemDialogData();

    /**
     * Sets the name of the item which we are adding/editing
     *
     * @param   name    Name of the item we're editing.
     */
    virtual void setName( const char* name );

    /**
     * Sets the current amount of time spent on the given item to 'seconds'.
     * Note that 'seconds' is automatically converted into the appropriate
     * amount of hours, minutes, and seconds before displaying it in the
     * dialog.
     *
     * @param   seconds Time spent on the given item
     */
    virtual void setTimeSpent( int seconds );

    /**
     * Gets the current name of the item.
     *
     * @return  Name of the item we're adding/editing.
     */
    virtual const char* name();

    /**
     * Gets the amount of time spent on the given item in seconds.
     *
     * @return  Time spent on the given item in seconds.
     */
    virtual int timeSpent();

    /**
     * En/disables the spin-buttons used to edit the amount of time spent on
     * the given item.
     *
     * @param   enabled Are the spin-buttons enabled?
     */
    virtual void enableTimeSpent( bool enabled );

public slots:

protected slots:

protected:
    /**
     * Handle to the widget in which the text for the item can be entered.
     */
    QLineEdit*  txtName;

    /**
     * Handle to the spin-button for the number of hours spent on this item.
     */
    QSpinBox*   spinHours;

    /**
     * Handle to the spin-button for the number of minutes spent on this item.
     */
    QSpinBox*   spinMinutes;

    /**
     * Handle to the spin-button for the number of seconds spent on this item.
     */
    QSpinBox*   spinSeconds;
};

#endif // ItemDialogData_included
