/*
 * kwidgetprobe.cpp  -  description
 * 
 *   Created              : Fri Jan 21 2000
 *   Copyright            : (C) 2000 by Richard Moore
 *   Email                : rich@kde.org
 */

/*
 *                                                                         
 *   This program is free software; you can redistribute it and/or modify  
 *   it under the terms of the GNU General Public License as published by  
 *   the Free Software Foundation; either version 2 of the License, or     
 *   (at your option) any later version.                                   
 *                                                                         
 */

#include "kwidgetprobe.h"
#include <kapp.h>
#include <qtimer.h>
#include <qcursor.h>
#include <qpopupmenu.h>
#include <qmenudata.h>
#include <qlabel.h>
#include <qbutton.h>
#include "kspeech.h"
#include "kwidgetprobe.moc"

KWidgetProbe::KWidgetProbe( QObject *parent, const char *name )
 : QObject(parent,name)
{
  timeout = 2000;
  timer = new QTimer( this );
  queryFlags = QueryFocusWidget | QueryPointerWidget | QueryWidgetItem;
	
  connect( timer, SIGNAL(timeout()), this, SLOT(probe()) );
  timer->start( timeout );
}

KWidgetProbe::KWidgetProbe( int millis, uint flags, QObject *parent, const char *name )
  : QObject(parent,name)
{
  queryFlags = flags;
  timeout = millis;

  timer = new QTimer( this );
  connect( timer, SIGNAL(timeout()), this, SLOT(probe()) );
  timer->start( timeout );
}

KWidgetProbe::~KWidgetProbe()
{
}

/**
 * Tells the class to do it's stuff - ie. figure out
 * which widget is under the mouse pointer and
 * report it.
 */
void KWidgetProbe::probe()
{
  if ( queryFlags & QueryFocusWidget ) {
    QWidget *focus = kapp->focusWidget();
    if ( focus ) {
      //      warning( "Focus: %s", focus->className() );
    }
    
    emit focusWidget( focus );
  }

  QPoint pos = QCursor::pos();
	
  if ( queryFlags & QueryPointerWidget ) {
    QWidget *pointed = kapp->widgetAt( pos, true );
    
    if ( pointed ) {
      //      warning( "Pointer: %s", pointed->className() );
      // FIXME This should be a method
      if ( queryFlags & QueryWidgetItem ) {
	if ( pointed->inherits("QPopupMenu") ) {
	  QPopupMenu *popup = (QPopupMenu *) pointed;
	  int id = popup->idAt( popup->mapFromGlobal( pos ) );

	  if ( id != -1 ) {
	    KSpeech::getSynth()->say( popup->text( id ) );

	    warning( "PopupItem: %s", popup->text( id ).data() );
	  }
	}
	else if ( pointed->inherits("QButton") ) {
	  QButton *button = (QButton *) pointed;
	  
	  KSpeech::getSynth()->say( button->text() );

	}
	else if ( pointed->inherits("QLabel") ) {
	  QLabel *label = (QLabel *) pointed;
	  
	  KSpeech::getSynth()->say( label->text() );

	}
      }
      emit pointerWidget( pointed );
    }
  }
}

void KWidgetProbe::setQuery( uint flags )
{
	queryFlags = flags;
}

uint KWidgetProbe::query()
{
	return queryFlags;
}

void KWidgetProbe::setRefreshInterval( int millis )
{
	timeout = millis;
	timer->changeInterval( timeout );
}

int KWidgetProbe::refreshInterval()
{
	return timeout;
}



