/***************************************************************************
                          kquick.cpp  -  description
                             -------------------
    begin                : Mit Dez 22 03:21:27 CET 1999
    copyright            : (C) 1999 by Philipp Ghring
    email                : p.guehring@poboxes.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <html.h>
#include <dirent.h>
#include <sys/stat.h>
#include "kquick.h"

bool logQueries;

KQuick::KQuick(QWidget* parent=0, const char *name=0)
{
  struct dirent **namelist;
  int n;
  Translators=NULL;
  Act=&Translators;
  TestDir( "/.kde" );
  TestDir( "/.kde/share" );
  TestDir( "/.kde/share/config" );
  TestDir( "/.kde/share/apps" );
  QString dir( "/.kde/share/apps/" );
  dir += kapp->appName();
  TestDir( dir );
  logfile=NULL;
  QString filename = getenv( "HOME" );
  filename += "/.kde/share/apps/";
  filename += kapp->appName();
  filename += "/log.txt";
  //printf (i18n("Filename: %s\n"),(const char *)filename);
  if (logQueries)
  {
    logfile=fopen(filename,"a");
  }


  n = scandir("/usr/share/trans/plain", &namelist, 0, alphasort);
  if (n < 0) perror("scandir");
  else
    while(n--) if (namelist[n]->d_name[0]!='.') Insert(new BinaryC("/usr/share/trans/plain/",namelist[n]->d_name,0));

  n = scandir("/usr/share/trans/binary", &namelist, 0, alphasort);
  if (n < 0) perror("scandir");
  else
    while(n--) if (namelist[n]->d_name[0]!='.') Insert(new BinaryC("/usr/share/trans/binary/",namelist[n]->d_name,0xFF));

  n = scandir("/usr/share/trans/babylon", &namelist, 0, alphasort);
  if (n < 0) perror("scandir");
  else
    while(n--) if (namelist[n]->d_name[0]!='.' && strcasecmp("english.dic",namelist[n]->d_name)) Insert(new BabylonC("/usr/share/trans/babylon/",namelist[n]->d_name));


  htmlw=NULL;
  htmlw=new KHTMLView(this);
  //htmlw->setScrolling(true);
  //htmlw->resize(400,300);
  //htmlw->setMinimumSize(100,100);
  setView(htmlw);
  startTimer(500); // alle 500 Millisekunden
  timerEvent(NULL);

  QPopupMenu *filemenu=new QPopupMenu();
  filemenu->insertItem(i18n("E&xit"),kapp,SLOT(quit() ) );
  menuBar()->insertItem(i18n("&File"),filemenu);

  optionmenu=new QPopupMenu();
  optionmenu->setCheckable(true);
  optionmenu->insertItem(i18n("&Log Queries"),this,SLOT(switchlog() ),0,1 );
  optionmenu->setItemChecked(1,logQueries);
  menuBar()->insertItem(i18n("&Options"),optionmenu);
  menuBar()->insertItem(i18n("&Help"),kapp->getHelpMenu(true,i18n("Kquick fr KDE\n(C) 2000 Philipp Ghring")) );

  htmlw->begin();
  htmlw->write("<head></head><body>");
  htmlw->write(i18n("<H1>KQuick</H1>from Futureware 2001<P>Simply mark the word/acronym you want to have translated."));
  htmlw->write("</body>");
  htmlw->end();
  htmlw->parse();
  htmlw->show();
}

KQuick::~KQuick()
{
}

/** Gibt regelmig HTML Code aus */
void KQuick::timerEvent(QTimerEvent *ev)
{
  int found=0;
  QString searchtext;
  searchtext=QApplication::clipboard()->text();
  searchtext.simplifyWhiteSpace();
  searchtext.stripWhiteSpace();
  if (searchtext!=lastsearch)
  {
    if (logfile!=NULL)
      fprintf(logfile,"%s\n",(const char *)searchtext);
    htmlw->begin();
    htmlw->write("<head></head><body>");

    for(TransCList *i=Translators;i!=NULL;i=i->Next)
      found+=i->Tran->html(htmlw,searchtext);
    if (!found) htmlw->write(i18n("Nothing found! Please try to mark the word exactly."));
    htmlw->write("</body>");
    htmlw->end();
    htmlw->parse();
    htmlw->show();
    lastsearch=searchtext;
  }
}

void KQuick::resizeEvent( QResizeEvent * )
{
  //htmlw->setGeometry( 10, height() - 10 - 16, width() - 20, 16 );
  htmlw->resize( size());
}

// ----------------------------------------------------------------------------
// Function:    TestDir (const char* name)
// Parameters:  name    - Path to directory to test for/create underneath $HOME
// ----------------------------------------------------------------------------
// Tests for the existence of a given directory underneath $HOME and creates it
// if it doesn't exist.
// ----------------------------------------------------------------------------
void KQuick::TestDir(const char* name)
{
    DIR* dp;
    QString dir = getenv( "HOME" );
    dir += name;

    dp = opendir( dir );
    if (dp == NULL)
        mkdir( dir, S_IRWXU );
    else
        closedir( dp );
}
/** Fgt TranslatorKlasse in die Liste ein */
void KQuick::Insert(TransC *Clas){
  *Act=new TransCList(Clas);
  Act=&((*Act)->Next);
}

/**  */
void KQuick::switchlog(){
  printf("Click\n");
  logQueries=!logQueries;
  optionmenu->setItemChecked(1,logQueries);
  kapp->getConfig()->writeEntry("LogQueries",logQueries);

  //printf (i18n("Filename: %s\n"),(const char *)filename);
  if (logQueries)
  {
    QString filename = getenv( "HOME" );
    filename += "/.kde/share/apps/";
    filename += kapp->appName();
    filename += "/log.txt";
    logfile=fopen(filename,"a");
  }
  else
  {
    if (logfile!=NULL) fclose(logfile);
    logfile=NULL;
  }

}
