/***************************************************************************
                          kmsgmodemview.cpp  -  description
                             -------------------                                         
    begin                : Mon Apr  5 09:53:56 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qstrlist.h>
#include <ktablistbox.h>
#include <kmsgmodemview.h>

KMsgModemView::KMsgModemView(KApplication* a,QWidget *parent)
              :KTabListBox(parent)

{
	int twidth=0;
	int i=0;
	int cols=6;

	setNumCols( cols );
	clear();
	setSeparator('\t');
	// twidth = (int) (this->width() / 5);
  setColumn( 0, i18n("Id")			,	(fontMetrics()).width( i18n("Id") 			)+20 	);
  setColumn( 1, i18n("Type")		,	(fontMetrics()).width( i18n("Type") 		)+20 	);
  setColumn( 2, i18n("Message")	,	(fontMetrics()).width( i18n("Message") 	)+20 	);
  setColumn( 3, i18n("Time")		,	(fontMetrics()).width( i18n("Time") 		)+50 	);
  setColumn( 4, i18n("Sender")	,	(fontMetrics()).width( i18n("Sender") 	)+100 );
  setColumn( 5, i18n("Status")	,	(fontMetrics()).width( i18n("Status") 	)+100 );
	for( i=0; i < cols; i++ )
		twidth+=cellWidth( i );
  // Is there a way to set to fill to right initially
  setColumnWidth( cols-1, ((this->width())-twidth) );
}

KMsgModemView::~KMsgModemView()
{
}

void KMsgModemView::slotGotData(const ModemGeneralInfo &moGeneral,
																ModemMessageList moMsgList)
{
	struct ModemMsgInfoStruct *moInfo = 0;
	QString qstr 		= "";
	QString dtime 	= "";
	QString attrib 	= "";
	QString type		= "";
	
  clear();
  // now make a string and append it to the view
  typedef QListIterator<struct ModemMsgInfoStruct> MoListIterator;
  MoListIterator my( moMsgList );
  for ( my.toFirst(); my.current(); ++my )
  {
  	qstr = "";
  	moInfo = my.current();
  	// build dtime
  	if (moInfo->clockValid)
  	{
  		dtime.sprintf("%i:%i:%i",	moInfo->msgDay,moInfo->msgHour,
  															moInfo->msgMinute);
  	} else
  		dtime = i18n("not set");
  	// build status
  	switch (moInfo->msgAttribute)
  	{
  		case UnreleasedUnchecked: attrib = "ur, uc"; 	break;
  		case UnreleasedChecked	:	attrib = "ur, ch"; 	break;
  		case ReleasedChecked		:	attrib = "r, ch"; 	break;
  		default									: attrib = "???";
  	}
   	if ((moInfo->msgType) == Fax)
    {
    	type = i18n("Fax");
    	qstr.sprintf("%i\t%s\t%i p\t%s\t%s\t%s\t",moInfo->msgIndex,
    		type.data(),moInfo->msgSize,dtime.data(),moInfo->callerId.data(),attrib.data());
		} else {
    	type = i18n("Voice");
			qstr.sprintf("%i\t%s\t%i sec\t%s\t%s\t%s\t",moInfo->msgIndex,
				type.data(),moInfo->msgSize,dtime.data(),moInfo->callerId.data(),attrib.data());
		}
		//debug("Line-> %s",qstr.data());
 		appendItem(qstr);
 	}
}



