/***************************************************************************
                          resource.h  -  description                              
                             -------------------                                         
    begin                : Mon Apr  5 09:53:56 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES


///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_QUIT                10100


///////////////////////////////////////////////////////////////////
// View-menu entries                    
#define ID_VIEW_TOOLBAR             12010
#define ID_VIEW_STATUSBAR           12020
#define ID_VIEW_OPTIONS             12030

///////////////////////////////////////////////////////////////////
// Modem Menu
#define ID_MODEM_GET_INFO           13010
#define ID_MODEM_GET_MEMORY         13020
#define ID_MODEM_CLEAR_MEMORY       13030

#define ID_MODEM_RESET_CLOCK				13040
#define ID_MODEM_COMMIT_SETUP				13100

#define ID_MODEM_CONTROL						13200
#define ID_MODEM_INFO_DIALOG				13210
#define ID_MODEM_TERMINAL   				13220

#define ID_MODEM_VOICEMESSAGES			13230
#define ID_MODEM_VOICEDIAL					13240

///////////////////////////////////////////////////////////////////
// Config Menu
#define ID_CONFIG_CONFIG            14010

///////////////////////////////////////////////////////////////////
// Help-menu entries
#define ID_HELP                     1002
#define ID_HELP_ABOUT								1003
#define ID_HELP_ABOUT_QT						1004

///////////////////////////////////////////////////////////////////
// Fax Popup Menu entries
#define ID_FAX_POPUP_VIEW       		20010
#define ID_FAX_POPUP_SAVE       		20020
#define ID_FAX_POPUP_PRINT					20030
#define ID_FAX_POPUP_MAIL       		20040

///////////////////////////////////////////////////////////////////
// Voice Popup Menu entries
#define ID_VOICE_POPUP_SAVE     		30010
#define ID_VOICE_POPUP_PLAY_INTERN	30020
#define ID_VOICE_POPUP_PLAY_CARD		30030
#define ID_VOICE_POPUP_MAIL      		30040

#define ID_GENERIC_POPUP_SAVE				40010
#define ID_GENERIC_POPUP_MAIL				40020

///////////////////////////////////////////////////////////////////
// General application values
#define ID_STATUS_MSG               1001

#define IDS_DEFAULT                 i18n("KMsgModem is ready...")

#define IDS_APP_ABOUT          			i18n("This is KMsgModem\nVersion " VERSION \
                                    "\n(c) 1999 by TUhlmann@gmx.de" \
                                    "\n\nKMsgModem is a USR Modem" \
                                    "\nMemory transfer tool." \
                                    "\n\nKMsgModem was written using KDevelop." \
                                    "\nKMsgModem contains code (c) by Thomas Scheuermann.")


///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS 
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));connect(submenu,SIGNAL(highlighted(int)), SLOT(statusCallback(int)))


///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));connect(ToolBar, SIGNAL(highlighted(int,bool)), SLOT(statusCallback(int)))

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function ;break;

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;

#endif // RESOURCE_H



