/*
 *   khexedit - Versatile hex editor
 *   Copyright (C) 1999  Espen Sand, espensa@online.no
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _ABOUT_DIALOG_H_
#define _ABOUT_DIALOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qdialog.h>
#include <qframe.h>
#include <qstring.h>

#include <ktabctl.h>
#include <kurllabel.h>


class CURLLabel : public KURLLabel
{
  Q_OBJECT

  public:
    CURLLabel( QWidget *parent, const char *name = 0 );
    ~CURLLabel( void );

  protected:
    bool eventFilter( QObject *object, QEvent *e );

  signals:
    void leftClick( const QString & );
};  



class CAboutDialog : public QDialog 
{
  Q_OBJECT
    
  public:
    enum Page
    {
      page_general = 0,
      page_contributor,
      page_licence,
      page_MAX
    };

  public:
    CAboutDialog( QWidget *parent, const char *name = 0 );
    ~CAboutDialog( void );

  private slots:
    void urlClick( const QString & );

  private:
    QFrame *addPage( const QString &title );
    void createGeneralPage( void );
    void createContributorPage( void );
    void createLicencePage( void );

  private:
    KTabCtl *mTabControl;
    QFrame  *mPage[page_MAX];
};


#endif
