/*
	resultview.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef RESULTVIEW_H
#define RESULTVIEW_H

#include <ktmainwindow.h>
#include <ktablistbox.h>
#include <kapp.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <qstrlist.h>

#include "cathandler.h"

class MountPointContainer
{
public:
   QString category;
	QString catalog;
	QString mount_point;
};

class ResultView : public KTMainWindow
{
   Q_OBJECT
public: 
	ResultView(const char* title,const char* sep);
	~ResultView();
	void addResult(CatEntry* ce,KPath current_branch);
	void addMount(QString pcategory,QString pcatalog,QString pmount_point);
protected slots:
   void slotToolbarClicked(int item);
protected:
	void exportData();
	void gotoSelected();
	void open();
   void initToolbar();
   QStrList* results;
   KTabListBox* view;
   char list_separator;
   QList<MountPointContainer> mounts;
   enum {TOOLBAR_QUIT,TOOLBAR_GOTO,TOOLBAR_OPEN,TOOLBAR_EXPORT};
};

#endif
