/*
	renamedialog.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <kmsgbox.h>
#include "renamedialog.h"

renameDialog::renameDialog(QWidget *parent, const char *name, QString title, QString o_name) : QDialog(parent,name,true){
	initDialog();
	lb_oldname_info->setText(o_name);
	sle_newname->setText(o_name);
	sle_newname->setSelection(0,((QString)sle_newname->text()).length());
	old_name=o_name;
   connect(pb_ok,SIGNAL(clicked()),this,SLOT(slotOk()));
   connect(pb_cancel,SIGNAL(clicked()),this,SLOT(reject()));
   setCaption(title);
	sle_newname->setFocus();
	pb_ok->setDefault(true);
}

renameDialog::~renameDialog(){
}

void renameDialog::slotOk()
{
	QString str=sle_newname->text();
	if ((str.find('/') > -1) || (str.find('|') > -1))
	{
		KMsgBox::message(this,i18n("Message"),i18n("Invalid character in the name!"),KMsgBox::STOP);
	}
	else
	{
      if ((str != "") && (str != old_name))
      {
      	new_name=sle_newname->text();
      	accept();
      }
	}
}
