#!/usr/bin/perl -w

my ($KDEOUT, $GNOMEROOT, $KDEFILE, $KFILE, $BFILE, $BDIR, %gnomed, $ddata);

my @gpath = (shift, $ENV{'GNOMEDIR'}, "/opt/gnome");
while(@gpath) { last if defined($GNOMEROOT = shift @gpath); };

$GNOMEROOT .= "/share/gnome/apps";
$KDEOUT = $ENV{'HOME'}."/.kde/share/applnk/GNOME-Apps";

(-d $GNOMEROOT) or &perror("Unable to find GNOME in ", $GNOMEROOT);
mkdir($KDEOUT, 0700) or &perror("Unable to create folder ", $KDEOUT)
	unless (-d $KDEOUT);

chdir($GNOMEROOT);
open PIPE, "find . -type d |" or &perror("Unable to read GNOME menu");
while(<PIPE>) {
	chomp;
	mkdir($KDEOUT."/".$_, 0700) or &perror("Unable to create ", $_)
		unless(-d $KDEOUT."/".$_);
}
close PIPE;
wait;

open PIPE, "find . -type f |" or &perror("Unable to read GNOME menu");
CONVERT: while(<PIPE>) {
	chomp;
	next CONVERT unless /^(.*)\/([^\/]+)$/;
	$BDIR = $1;
	$GFILE = $2;
	$BFILE = $GFILE;
	$BFILE =~ s/\.desktop$//;
	$KFILE = $BFILE.".kdelnk";
	%gded = ();

	open GNOME, "<".$BDIR."/".$GFILE or eval {
		print STDERR "Unable to open ",$BDIR,"/",$GFILE,": ",$!,"\n";
		next CONVERT;
	};
	READ: while(<GNOME>) {
		last READ if /^\[Desktop Entry\]/;
	}
	READ: while(<GNOME>) {
		chomp;
		$gded{$1} = $2 if /^([^=]+)=(.*)$/;
	}
	close GNOME;

	open KDELNK, ">".$KDEOUT."/".$BDIR."/".$KFILE or eval {
		print STDERR "Unable to open ",$BDIR,"/",$KFILE,": ",$!,"\n";
		next CONVERT;
	};
	print KDELNK "# KDE Config File\n";
	print KDELNK "[KDE Desktop Entry]\n";
	$ddata = "Application" unless $ddata = $gded{'Type'};
	print KDELNK "Type=", $ddata, "\n";
	$ddata = $BFILE unless $ddata = $gded{'Name'};
	print KDELNK "Name=", $ddata, "\n";
	if(defined($gded{'Terminal'}) && ($gded{'Terminal'} eq "true")) {
		print KDELNK "Terminal=1\n";
	} else {
		print KDELNK "Terminal=0\n";
	}
	print KDELNK "Exec=", $gded{'Exec'}, "\n" if $gded{'Exec'};
	print KDELNK "Icon=", $gded{'Icon'}, "\n" if $gded{'Icon'};
	close KDELNK;
}
close PIPE;
wait;
exit;

sub perror {
	print STDERR @_, ": ", $!, "\n";
	exit;
}
