/***************************************************************************
                          menus.cpp  -  all of the programs menus
                             -------------------                                         
    begin                : Thu Jun 10 1999                                           
    copyright            : (C) 1999 by Eric Banker                         
    email                : ebanker@gmu.edu                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qfiledlg.h>
#include <qfile.h>
#include <kapp.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qstring.h>
#include "edit.h"

void Edit::initMenuBar()
{
// This would be the file menu

  QPopupMenu *file = new QPopupMenu;

    file->insertItem(klocale->translate("Open..."), ID_OPEN );
    file->insertItem(klocale->translate("New..."), ID_NEW );
		//file->insertSeparator();
		//file->insertItem(klocale->translate("Project"), ID_NOIMP);
    file->insertSeparator();
    file->insertItem(klocale->translate("Save"), ID_SAVE);
    file->insertItem(klocale->translate("Save As..."), ID_SAVEAS);
    file->insertSeparator();
    file->insertItem(klocale->translate("Print"), ID_NOIMP29);
    file->insertSeparator();
    file->insertItem(klocale->translate("Close File"), ID_CLOSEWINDOW);
    file->insertItem(klocale->translate("New Window"), ID_NEW_WINDOW);
    file->insertSeparator();
    file->insertItem(klocale->translate("Exit"), ID_EXIT);

// Edit Menu Items

  QPopupMenu *mnuedit = new QPopupMenu;

    mnuedit->insertItem( klocale->translate("Cut"), this, SLOT(cut()));
    mnuedit->insertItem( klocale->translate("Copy"), this, SLOT(copy()));
    mnuedit->insertItem( klocale->translate("Paste"), this, SLOT(paste()));
		mnuedit->insertSeparator();
    mnuedit->insertItem( klocale->translate("Find"), ID_NOIMP2);
    mnuedit->insertItem( klocale->translate("Find/Replace"), ID_NOIMP3);
		mnuedit->insertSeparator();
    mnuedit->insertItem( klocale->translate("Select All"), this, SLOT(select_all()));

// **********************************************************
// The following are the Submenus for the mnuhtml menu items
// **********************************************************

  QPopupMenu *mnuheader = new QPopupMenu;
    mnuheader->insertItem( klocale->translate("H1"), this, SLOT(InsertH1()));
    mnuheader->insertItem( klocale->translate("H2"), this, SLOT(InsertH2()));
    mnuheader->insertItem( klocale->translate("H3"), this, SLOT(InsertH3()));
    mnuheader->insertItem( klocale->translate("H4"), this, SLOT(InsertH4()));
    mnuheader->insertItem( klocale->translate("H5"), this, SLOT(InsertH5()));
    mnuheader->insertItem( klocale->translate("H6"), this, SLOT(InsertH6()));

 QPopupMenu *mnutags = new QPopupMenu;

    mnutags->insertItem( klocale->translate("Page Body"), this, SLOT(InsertBody()));
    mnutags->insertSeparator();
		mnutags->insertItem( klocale->translate("Center"), this, SLOT(InsertCenter()));
    mnutags->insertItem( klocale->translate("Right Align"), this, SLOT(InsertRight()));
    mnutags->insertItem( klocale->translate("HR Rule"), this, SLOT(InsertHRrule()));
		mnutags->insertSeparator();
    mnutags->insertItem( klocale->translate("Line Break"), this, SLOT(InsertBR()));
		mnutags->insertItem( klocale->translate("Paragraph"), this, SLOT(InsertParagraph()));
		mnutags->insertItem( klocale->translate("Non-Breaking Space"), this, SLOT(InsertNbs()));
		mnutags->insertSeparator();
		mnutags->insertItem( klocale->translate("Embed Link"), this, SLOT(InsertLink()));
    mnutags->insertItem( klocale->translate("Embed Image"), this, SLOT(InsertImage()));

 QPopupMenu *mnufont = new QPopupMenu;
    mnufont->insertItem( klocale->translate("Font Header"), this, SLOT(InsertfontH()));
    mnufont->insertSeparator();
    mnufont->insertItem( klocale->translate("Headers"), mnuheader);
    mnufont->insertSeparator();
    mnufont->insertItem( klocale->translate("Bold"), this, SLOT(InsertBold()));
    mnufont->insertItem( klocale->translate("Italic"), this, SLOT(InsertItalic()));
    mnufont->insertItem( klocale->translate("Underline"), this, SLOT(InsertUline()));
    mnufont->insertSeparator();
    mnufont->insertItem( klocale->translate("Font Size +1"), this, SLOT(Insertfontp()));
    mnufont->insertItem( klocale->translate("Font Size -1"), this, SLOT(Insertfontm()));
    mnufont->insertSeparator();
		mnufont->insertItem( klocale->translate("Font Footer"), this, SLOT(InsertfontF()));

  QPopupMenu *mnuform = new QPopupMenu;
    mnuform->insertItem( klocale->translate("Form Header"), this, SLOT(InsertFormH()));
    mnuform->insertSeparator();
    mnuform->insertItem( klocale->translate("Text Box"), this, SLOT(InsertTextB()));
    mnuform->insertItem( klocale->translate("Text Field"), this, SLOT(InsertTextF()));
    mnuform->insertSeparator();
    mnuform->insertItem( klocale->translate("Radio Button"), this, SLOT(InsertRadio()));
    mnuform->insertItem( klocale->translate("Check Box"), this, SLOT(InsertCheck()));
    mnuform->insertItem( klocale->translate("List Box"), this, SLOT(InsertListB()));
    mnuform->insertSeparator();
    mnuform->insertItem( klocale->translate("Reset Button"), this, SLOT(InsertReset()));
    mnuform->insertItem( klocale->translate("Submit Button"), this, SLOT(InsertSubmit()));
    mnuform->insertSeparator();
    mnuform->insertItem( klocale->translate("Form Footer"), this, SLOT(InsertFormF()));

  QPopupMenu *mnulist = new QPopupMenu;
    mnulist->insertItem( klocale->translate("Organized list"), this, SLOT(InsertOLScript()));
    mnulist->insertItem( klocale->translate("UnOrganized list"), this, SLOT(InsertULScript()));
    mnulist->insertSeparator();
		mnulist->insertItem( klocale->translate("OL Tag"), this, SLOT(InsertOL()));
		mnulist->insertItem( klocale->translate("UL Tag"), this, SLOT(InsertUL()));
    mnulist->insertItem( klocale->translate("LI Tag"), this, SLOT(InsertLI()));

  QPopupMenu *mnuframes = new QPopupMenu;
    mnuframes->insertItem( klocale->translate("Frame Header"), this, SLOT(InsertFrameH()));
		mnuframes->insertSeparator();
    mnuframes->insertItem( klocale->translate("Frame Tag"), this, SLOT(InsertFrameTag()));
    mnuframes->insertItem( klocale->translate("No Frames"), this, SLOT(InsertNoFrames()));
		mnuframes->insertSeparator();
		mnuframes->insertItem( klocale->translate("Frame Footer"), this, SLOT(InsertFrameFooter()));

  QPopupMenu *mnutable = new QPopupMenu;
    mnutable->insertItem( klocale->translate("Table Header"), this, SLOT(InsertTableHeader()));
    mnutable->insertSeparator();
    mnutable->insertItem( klocale->translate("TR Tag"), this, SLOT(InsertTableTR()));
    mnutable->insertItem( klocale->translate("TD Tag"), this, SLOT(InsertTableTD()));
    mnutable->insertSeparator();
    mnutable->insertItem( klocale->translate("Table Footer"), this, SLOT(InsertTableFooter()));

// **********************************************************
// End the Submenus for the mnuhtml menu items
// **********************************************************

// This is the Tags sub menu

  QPopupMenu *mnuhtml = new QPopupMenu;

    mnuhtml->insertItem( klocale->translate("Basic Html"), mnutags);
    mnuhtml->insertItem( klocale->translate("Font Tags"), mnufont);
    mnuhtml->insertItem( klocale->translate("Form Tags"), mnuform);
    mnuhtml->insertItem( klocale->translate("List Tags"), mnulist);
    mnuhtml->insertItem( klocale->translate("Frame Tags"), mnuframes);
    mnuhtml->insertItem( klocale->translate("Table Tags"), mnutable);

// When i make tools they will go here

  QPopupMenu *mnutools = new QPopupMenu;

    mnutools->insertItem( klocale->translate("View in Netscape"), this, SLOT(execNetscape()));

// This is the Scripts Sub Menu

  QPopupMenu *mnuscripts = new QPopupMenu;

    mnuscripts->insertItem( klocale->translate("Java Scripts"), ID_NOIMP27);

// This is the VIEW Sub menu

  QPopupMenu *mnutoolbar = new QPopupMenu;

		mnutoolbar->insertItem( klocale->translate("Show Main Tools"), this, SLOT(toggleMainToolbar()));
		mnutoolbar->insertItem( klocale->translate("Show Html Tools"), this, SLOT(toggleHtmlToolbar()));
		mnutoolbar->insertItem( klocale->translate("Show Font Tools"), this, SLOT(toggleFontToolbar()));
		mnutoolbar->insertItem( klocale->translate("Show List/Table Tools"), this, SLOT(toggleLTToolbar()));
		mnutoolbar->insertItem( klocale->translate("Show Form Tools"), this, SLOT(toggleFormToolbar()));
		mnutoolbar->insertItem( klocale->translate("Show Special Chars"), this, SLOT(toggleSpecialToolbar()));

// This is the Help Sub menu

  QPopupMenu *help = new QPopupMenu;
    /* help->insertItem( klocale->translate("Contents..."), ID_HELPCONTENTS);*/
    help->insertItem( klocale->translate("About &KWebDev"), ID_ABOUT);
		help->insertItem( klocale->translate("About K&DE"), ID_ABOUTKDE);

// This would be the main menu

	menu = new KMenuBar( this );
  CHECK_PTR( menu );
    menu->insertItem( klocale->translate("&File"), file );
    menu->insertSeparator();
    menu->insertItem( klocale->translate("&Edit"), mnuedit);
    menu->insertSeparator();
    menu->insertItem( klocale->translate("T&ools"), mnutools);
    menu->insertSeparator();
    menu->insertItem( klocale->translate("&Tags"), mnuhtml);
    menu->insertSeparator();
	  menu->insertItem( klocale->translate("&Scripts"), mnuscripts);
    menu->insertSeparator();
	  menu->insertItem( klocale->translate("&View"), mnutoolbar);
    menu->insertSeparator();
    menu->insertItem( klocale->translate("&Help"), help );
    menu->show();
  setMenu(menu);

  // Connect to the menus

  connect (file, SIGNAL (activated (int)), SLOT (commandCallback (int)));
  connect (help, SIGNAL (activated (int)), SLOT (commandCallback (int)));
}