/***************************************************************************
                          functions.cpp  -  functions for program stuff
                             -------------------                                         
    begin                : Sat Jun 12 1999                                           
    copyright            : (C) 1999 by Eric Banker                         
    email                : ebanker@gmu.edu                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qfiledlg.h>
#include <qfile.h>
#include <kapp.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qstring.h>
#include "edit.h"

// Here are global functions

void Edit::textChanged()
{
  modified= true;
  enableCommand(ID_SAVE);
  enableCommand(ID_SAVEAS);
}

void Edit::enableCommand(int id)
{
  toolbar->setItemEnabled(id, true);
  menu->setItemEnabled(id, true);
}

void Edit::disableCommand(int id)
{
  toolbar->setItemEnabled(id, false);
  menu->setItemEnabled(id, false);
}

void Edit::setHint(const char *text)
{
  statusbar->changeItem(text, ID_HINTTEXT);
}

void Edit::closeEvent(QCloseEvent *e)
{
  if (exit())
    e->accept();
}

// Functions for the File Menu

void Edit::load(const char *filename) {
    QFile f( filename );
    if ( !f.open( IO_ReadOnly ) )
	return;

    view->setAutoUpdate( FALSE );
    view->clear();

    QTextStream t(&f);
    while ( !t.eof() ) {
	  QString s = t.readLine();
	  view->append( s );
    }
    f.close();

    view->setAutoUpdate( TRUE );
    view->repaint();
    modified= false;
    filename_= filename;
		statusbar->changeItem(filename, ID_HINTTEXT);
}

void Edit::saveAs(const char *filename) {
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) )
	return;

    QTextStream t(&f);

    t << view->text();

    f.close();
    modified= false;
    filename_= filename;
	  statusbar->changeItem(filename, ID_HINTTEXT);
}

void Edit::Print()
{
  QMessageBox::about(this, "HMMMM....",
		       "Looks like this has not been implemented yet\nSorry in a future version.");
}

void Edit::closefile()
{
  if (!modified)
  {
    view->clear();
    modified = FALSE;
    view->setCursorPosition(0, 0, false);
		statusbar->changeItem("No File Loaded", ID_HINTTEXT);
  }
  else
  {
     if (QMessageBox::warning(this, klocale->translate("Unsaved Changes"),
			      "You have unsaved changes, you will loose them "
			      "if you close the file now.",
			      "OK", "Cancel", 0, 1, 1))
     {
        view->deselect();
     }
     else
     {
       view->clear();
		   modified = FALSE;
		   view->setCursorPosition(0, 0, false);
			 statusbar->changeItem("No File Loaded", ID_HINTTEXT);
     }
  }
}

int Edit::exit()
{
  int die= 0;

  if (!modified)
    die= 1;
  else
    if (QMessageBox::warning(this, klocale->translate("Unsaved Changes"),
			      "You have unsaved changes, you will loose them "
			      "if you exit now.",
			      "Exit", "Cancel",
			      0, 1, 1))
      die= 0;
    else
      die= 1;

  return die;
}

/* these are for the edit menu */

void Edit::copy()
{
	view->copyText();	
}

void Edit::cut()
{
	view->cut();
	modified=true;
}

void Edit::paste()
{
	view->paste();
	modified=true;
}

void Edit::select_all()
{
	view->selectAll();	
}

// This is for the tools menu

void Edit::execNetscape()
{
QMessageBox::about(this, "Execute Netscape",
		       "Sorry this feature is not yet available.");
}

// This is for the help menu
void Edit::help()
{
  kapp->invokeHTMLHelp("", "");
}

void Edit::aboutkde()
{
    QMessageBox::about(this, "About KDE",
		       "The KDE Desktop Environment was written by the KDE Team,\na world-wide network of software engineers committed to\nfree software development\n\nVist http://www.kde.org for more information on the KDE\nProject. Please consider joining and supporting KDE.\n\nPlease report bugs at http://bugs.kde.org");	
}

void Edit::aboutkwebdev()
{
   QMessageBox::about(this, "About KWebDev",
		       "Welcome to KWebDev\n-------------------------------------\n\nYou are using Version 0.3 of KWebDev\n\nKWebDev is written by Eric Banker <ebanker@gmu.edu>\nWebpage: http://mason.gmu.edu/~ebanker/kwebdev\n\n KWebDev is released under the GPL license");
}

















