/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Aug 10 12:57:07 MEST 1999
                                           
    copyright            : (C) 1999 by Guenter Schwann                         
    email                : vogel@ibk.dyn.priv.at                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <kapp.h>
#include <kconfig.h>

#include "main.h"
#include "parser.h"
#include <qstring.h>
#include <qfileinfo.h>
#include <qmessagebox.h>


KDEkeafApplication::KDEkeafApplication(int &argc, char *argv[], const char *name) :
    KControlApplication(argc, argv, name)
{

 QString qs;
 pa = new Parser();

 pa->SearchCFile();
 qs=pa->CFileName();
 if ( !qs.isEmpty() ) pa->ReadConfig( qs );

 QFileInfo qfinfo(qs.data());

    keafnode = new KDEkeafConfig(pa, dialog, "keafnode");
    keafnode->setMinimumSize(420,250);
    keafnode3 = new KDEkeafConfig3(pa, dialog, "keafnode3");
    keafnode4 = new KDEkeafConfig4(pa, dialog, "keafnode4");
    addPage(keafnode, "main", "index-3.html");
    addPage(keafnode3, "expire", "index-4.html");
    addPage(keafnode4, "specials", "index-5.html");

 if (qfinfo.isWritable()==false)
 {
  qs="You don't have permission to write the config-file\n";
  qs=qs+pa->CFileName()+"\n\n";
  qs=qs+"Do you still want to continue?\n";
  switch (QMessageBox::warning(keafnode,"keafnode",qs.data(),"OK","Quit"))
  {
   case 0: run=true; break;
   case 1: run=false; break;
   default: run=false;
  }
 }
   dialog->show();
}

void KDEkeafApplication::init()
{
    keafnode->loadSettings();
    keafnode3->loadSettings();
    keafnode4->loadSettings();
}


void KDEkeafApplication::apply()
{
    keafnode->applySettings();
    keafnode3->applySettings();
    keafnode4->applySettings();
}

void KDEkeafApplication::defaultValues()
{
    keafnode->defaultSettings();
    keafnode3->defaultSettings();
    keafnode4->defaultSettings();
}

bool KDEkeafApplication::runit()
{
 return run;
}


//
// Main application
//

int main(int argc, char **argv)
{
    KDEkeafApplication app(argc, argv, "keafnode");


    if (app.runGUI() && app.runit())
	return app.exec();
    else
	return 0;
}


