#ifndef ktracklst_h
#define ktracklst_h

/*
 *
 * $Id: ktracklst.h,v 1.2 1998/08/05 16:36:04 core Exp $
 *
 */

#include <qstring.h>
#include <qwidget.h>

#include <ktablistbox.h>
#include "ocdrom.h"


/**
   used internaly to store data about tracks on this list
 */
struct TrackListItem 
{
  CdTrackInfo *track;
  QString filename;
  QString title;
};


#define DSbuffer 0
#define DSreadAudiCd 1
#define DSreadDataCd 2
#define DSmasterDataCd 3

class KTrackListBox;

/**
   Stores the data which is draged from one widget into another
   Nothing unusual here....   
*/
struct DragData
{
  int dragSource;
  KTrackListBox *listBox;
};


/**
   A listbox which stores CdTrackInfo tracks + title and filname.
   Theres some support to simplify dragn drop.
*/
class KTrackListBox : public KTabListBox
{
  Q_OBJECT

 public:
  KTrackListBox( QWidget *parent=0, const char *name=0, int columns=1, WFlags f=0 );
  virtual ~KTrackListBox();

  virtual void setColor( int index );

  virtual void allowDrag( bool allow = true );
  virtual void showTitle( bool show = true );
  virtual void setDragSource( int dragData );

  virtual int insertTrack( CdTrackInfo *track, QString title = "", QString filename = "", int index = -1 );
  virtual void removeTrack( int index );
  virtual CdTrackInfo *track( int index );
  virtual int pos( CdTrackInfo *track );
  virtual int count();
  
  virtual void setFilename( int index, QString filename );
  virtual QString filename( int index );
  virtual void setTitle( int index, QString title );
  virtual QString title( int index );
  
  virtual void dragEndEvent();

 signals:
  void dragEnded( int index );

 protected:
  virtual bool prepareForDrag( int col, int row, char **data, int *size, int *type );

  QString printLine( int index );

  DragData dd;

  bool _allowDrag,  _showTitle;
  int _dragSource;
  TrackListItem *list[100];          // ToDo: make it a REAL list
  int listCount;
};

#endif
