/***************************************************************************
                          kminfoview.cpp  -  description
                             -------------------
    begin                : Fri Jan 7 2000
    copyright            : (C) 2000 by Ian Zepp
    email                : icszepp@islc.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kminfoview.h"

KmInfoView::KmInfoView(QWidget *parent, const char *name): QWidget(parent,name){
	this->setCaption(i18n("Kmap: Information"));

	pix = new QPixmap();

	mainView = new QListView(this);
	mainView->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	mainView->setAllColumnsShowFocus(true);
	mainView->setRootIsDecorated(true);
	mainView->setSorting(0, true);

	mainView->addColumn(i18n("The Problem"));
	mainView->addColumn(i18n("The Solution"));
}
KmInfoView::~KmInfoView(){
}

void KmInfoView::Clear()
{
	mainView->clear(); // clears listview

	i_cnt = 0;
	in_port_list = false;
	in_fingerprint = false;

	current_ip = "";
	tcp_port_list = "";
	udp_port_list = "";
	misc_port_list = "";

	our_problem = "";
	our_solution = "";
}

void KmInfoView::slotStarted()
{
	Clear();
}

void KmInfoView::slotStdout(const QString &text)
{
	if (in_port_list)
	{
		// This has to be first, because this function will flush
		// outstanding info when done getting data
		handlePortEntry(text);

		if (text.isEmpty())
			in_port_list = false;
		return; // no more parsing allowed here
	}

	if (in_fingerprint)
	{
		// This has to be first, because this function will flush
		// outstanding info when done getting data
		handlePrintEntry(text);

		if (text.isEmpty())
			in_fingerprint = false;
		return; // no more parsing allowed here
	}

	// Search for middle of line strings first
	if (text.find(QRegExp("Class=")) != -1)
		handleClass(text); // in middle of line

	if (text.find(QRegExp("Difficulty=")) != -1)
		handleDifficulty(text); // in middle of line

	// Search for start of line strings next
	if (text.find(QRegExp("^Port ")) != -1)
		in_port_list = true;

	if (text.find(QRegExp("^TCP/IP fingerprint:")) != -1)
		in_fingerprint = true;

	if (text.find(QRegExp("^No OS matches for host ")) != -1)
		handleUnknownOS(text);

	if (text.find(QRegExp("^Interesting ports on ")) != -1)
		handleIpAddress(text);

	if (text.find(QRegExp("^Host [a-zA-Z\\.]+")) != -1)
		handleIpAddress2(text);

	if (text.find(QRegExp("^Sequence numbers:")) != -1)
		handleSequence(text);

	if (text.find(QRegExp("^Remote operating system guess:")) != -1)
		handleRemoteOS(text);

	if (text.find(QRegExp("^Remote OS guesses:")) != -1)
		handleRemoteOS(text);

}
void KmInfoView::slotStderr(const QString &text)
{
}
void KmInfoView::slotExited()
{
}

void KmInfoView::handlePortEntry(const QString &text)
{
	if (text.isEmpty())// handle this first
	{
		if (!tcp_port_list.isEmpty())
		{
			our_problem  = i18n("Open TCP ports:");
			our_solution = tcp_port_list;

			(void) new QListViewItem(p_currentip, our_problem, our_solution);
		}

		if (!udp_port_list.isEmpty())
		{
			our_problem  = i18n("Open UDP ports:");
			our_solution = udp_port_list;

			(void) new QListViewItem(p_currentip, our_problem, our_solution);
		}

		if (!misc_port_list.isEmpty())
		{
			our_problem  = i18n("Unknown-type ports:");
			our_solution = misc_port_list;

			(void) new QListViewItem(p_currentip, our_problem, our_solution);
		}

		in_port_list = false;

		return;
	}

	QString port = text.left(text.find(" "));

	if (text.find(QRegExp("tcp")) != -1)
		tcp_port_list += port + ",";
	else if (text.find(QRegExp("udp")) != -1)
		udp_port_list += port + ",";
	else
		misc_port_list += port + ",";

}
void KmInfoView::handlePrintEntry(const QString &text)
{
	// For now just ignore the fingerprint
}
void KmInfoView::handleIpAddress(const QString &text)
{
	int start = text.find("(") + 1;
	int stop = text.find(")");
	int len = stop - start;

	current_ip = text.mid(start, len);
	tcp_port_list = "";
	udp_port_list = "";
	misc_port_list = "";

	// Name to problem
	our_problem = current_ip;

	// Try to extract a hostname
	our_solution = text.left(start - 1);
	our_solution.replace(QRegExp("^Interesting ports on "), "");
	our_solution.replace(QRegExp("\\s"), "");

	if (our_solution.isEmpty())
		our_solution = i18n("IP address did not resolve");
	else
		our_solution.prepend(i18n("IP address resolved to: "));

	// Set current ip address and add in ..
	p_currentip = new QListViewItem(mainView, our_problem, our_solution);
}
void KmInfoView::handleIpAddress2(const QString &text)
{
	int start = text.find("(") + 1;
	int stop = text.find(")");
	int len = stop - start;

	current_ip = text.mid(start, len);
	tcp_port_list = "";
	udp_port_list = "";
	misc_port_list = "";

	// Name to problem
	our_problem = current_ip;

	// Try to extract a hostname
	our_solution = text.left(start - 1);
	our_solution.replace(QRegExp("^Host "), "");
	our_solution.replace(QRegExp("\\s"), "");

	if (our_solution.isEmpty())
		our_solution = i18n("IP address did not resolve");
	else
		our_solution.prepend(i18n("IP address resolved to: "));

	// Set current ip address and add in ..
	p_currentip = new QListViewItem(mainView, our_problem, our_solution);
}
void KmInfoView::handleClass(const QString &text)
{
	our_problem = i18n("Sequence class: ");
	our_solution = text.mid(text.find("=") + 1, text.length());
	our_solution.stripWhiteSpace();

	(void) new QListViewItem(p_currentip, our_problem, our_solution);
}
void KmInfoView::handleDifficulty(const QString &text)
{
	our_problem = i18n("Sequence difficulty: ");
	our_solution = text.mid(text.find("=") + 1, text.length());
	our_solution.stripWhiteSpace();

	(void) new QListViewItem(p_currentip, our_problem, our_solution);
}
void KmInfoView::handleSequence(const QString &text)
{
	our_problem = i18n("Sequence numbers: ");
	our_solution = text.mid(text.find(":") + 1, text.length());
	our_solution.stripWhiteSpace();

	(void) new QListViewItem(p_currentip, our_problem, our_solution);
}
void KmInfoView::handleRemoteOS(const QString &text)
{
	our_problem = i18n("Remote OS: ");
	our_solution = text.mid(text.find(":") + 1, text.length());
	our_solution.stripWhiteSpace();

	(void) new QListViewItem(p_currentip, our_problem, our_solution);
}
void KmInfoView::handleUnknownOS(const QString &text)
{
	our_problem = i18n("Unknown OS: ");
	our_solution = i18n("No OS matches for host");
	our_solution.stripWhiteSpace();

	(void) new QListViewItem(p_currentip, our_problem, our_solution);
}


void KmInfoView::paintEvent(QPaintEvent *event)
{
	this->QWidget::paintEvent(event);

	int w_prob = 150;

	mainView->setGeometry(0, 0, width(), height());	
	mainView->setColumnWidth(0, w_prob);
	mainView->setColumnWidth(1, width() - w_prob - 20);
}

/*
 * Asks the main kmap to hide me nicely
 */
void KmInfoView::closeEvent( QCloseEvent *event )
{
	QWidget::closeEvent(event);

	// Tell hidden
	emit sigHidden();
}
























