/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>

#include "pcidevice.h"
#include "propdialog.h"


PropertiesDialog::PropertiesDialog(Device *device, QWidget *parent, 
				   const char *name) : QTabDialog(parent, name, true),
						       _device(device)
{
  setCaption(QString(i18n("Properties of ")+_device->deviceName()));
  setMinimumSize(300, 400);
  setCancelButton();

  _genproptab = new GeneralPropertiesTab(_device,  this, "genproptab");  
  addTab(_genproptab, i18n("General"));

  if (_device->firstResource())
  {
    _resproptab = new ResourcePropertiesTab(_device, this, "resproptab");
    addTab(_resproptab, i18n("Resources"));
  }

  if ((_device->deviceBaseClass() == Device::BaseClassMassStorage) || 
      (_device->deviceBaseClass() == Device::BaseClassCDROM))
  {
    _setproptab = new SettingsPropertiesTab(_device, this, "setproptab");
    addTab(_setproptab, i18n("Settings"));  
  }
  
  resize(400, 420);  
}


