/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __IOADDRESS_H
#define __IOADDRESS_H

#include <kapp.h>

#include "resource.h"


class IOAddress : public Resource
{
  public:
  
    IOAddress(ulong ioval = 0x0000, ulong range = 1);
    ~IOAddress() {}
  
    void     setAddress(ulong ioval) { setResourceValue(ioval); }
    void     setRange(ulong range)   { setResourceRange(range); }
  
    bool     operator==(const IOAddress&) const;
    
    QString  resourceName()    const { return i18n("I/O area"); }
    restype  resourceType()    const { return ResIOAddress;     }
};


#endif
