/*
    This file is part of the Okteta Core library, part of the KDE project.

    Copyright 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library. If not, see <http://www.gnu.org/licenses/>.
*/

#include "kcharcodectest.h"

// test object
#include <charcodec.h>
// lib
#include <character.h>
// KDE
#include <kcomponentdata.h>
// Qt
#include <QtTest/QtTest>


namespace Okteta
{

KComponentData* componentData;


void KCharCodecTest::initTestCase()
{
    componentData = new KComponentData( "KTextCharCodecTest" );
}

void KCharCodecTest::cleanupTestCase()
{
    delete componentData;
}

//---------------------------------------------------------------------------- Tests -----


void KCharCodecTest::testCodecNames()
{
    const QStringList list( CharCodec::codecNames() );

    foreach( const QString& name, list )
    {
        CharCodec* codec = CharCodec::createCodec( name );
        QCOMPARE( codec->name(), name );
        delete codec;
    }
}

}

QTEST_MAIN( Okteta::KCharCodecTest )
