/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2008                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Wed Jun 18 2003
 */

#ifndef CODEBLOCK_H
#define CODEBLOCK_H


#include "textblock.h"


/**
 * A "chunk" of code within the code document.
 */
class CodeBlock : public TextBlock
{
    Q_OBJECT
public:

    /**
     * Describes the creation of the content.
     * @enum AutoGenerated  the content was generated by code generation itself
     * @enum UserGenerated  the content was entered by the user
     */
    enum ContentType {AutoGenerated=0, UserGenerated };

    /**
     * Constructor with QString so we can create and populate it in
     * one step.
     * @param parent   the parent of this code block
     * @param body     the code or body of this code block
     */
    explicit CodeBlock ( CodeDocument * parent, const QString & body = "");

    /**
     * Empty Destructor
     */
    virtual ~CodeBlock ( );

    /**
     * Set the value of m_contentType
     * specifies whether the content (text) of this object was generated by the code
     * generator or was supplied by the user.
     * @param new_var the new value of m_contentType
     */
    void setContentType ( ContentType new_var );

    /**
     * Get the value of m_contentType
     * specifies whether the content (text) of this object was generated by the code
     * generator or was supplied by the user.
     * @return the value of m_contentType
     */
    ContentType getContentType ( ) const;

    /**
     * Return a string representation of ContentType.
     *
     * @param  val  the enum value of the ContentType
     * @return      the string representation of the enum
     */
    static QString enumToString(const ContentType& val);

    /**
     * Save the XMI representation of this object.
     * @param doc    the xmi document
     * @param root   the starting point to append
     */
    virtual void saveToXMI ( QDomDocument & doc, QDomElement & root );

    /**
     * Load params from the appropriate XMI element node.
     * @param root   the starting point to load from
     */
    virtual void loadFromXMI ( QDomElement & root );

    /**
     * Set the class attributes from a passed object.
     * @param obj   text block from which the attributes are taken
     */
    virtual void setAttributesFromObject (TextBlock * obj);

protected:

    /**
     * Set attributes of the node that represents this class
     * in the XMI document.
     * @param doc            the xmi document
     * @param blockElement   the xmi element holding the attributes
     */
    virtual void setAttributesOnNode ( QDomDocument & doc, QDomElement & blockElement);

    /**
     * Set the class attributes of this object from
     * the passed element node.
     * @param element   the xmi element from which to load
     */
    virtual void setAttributesFromNode ( QDomElement & element);

    friend QTextStream& operator<<(QTextStream& str, const CodeBlock& obj);

private:

    // specifies whether the content (text) of this object
    // was generated by the code generator or was supplied by the user (or some other way).
    ContentType m_contentType;

};

QTextStream& operator<<(QTextStream& str, const CodeBlock& obj);

#endif // CODEBLOCK_H
