
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Wed Jun 18 2003
 */

#include "codeblock.h"

#include "kdebug.h"

#include "codedocument.h"


CodeBlock::CodeBlock ( CodeDocument * doc, const QString & body )
        : TextBlock ( doc, body )
{
    m_contentType = AutoGenerated;
}

CodeBlock::~CodeBlock ( )
{
}

void CodeBlock::setContentType ( ContentType new_var )
{
    m_contentType = new_var;
}

CodeBlock::ContentType CodeBlock::getContentType ( ) const
{
    return m_contentType;
}

void CodeBlock::saveToXMI ( QDomDocument & doc, QDomElement & root )
{
    QDomElement blockElement = doc.createElement( "codeblock" );
    // set attributes
    setAttributesOnNode(doc, blockElement);
    root.appendChild( blockElement );
}

void CodeBlock::setAttributesOnNode( QDomDocument & doc, QDomElement & blockElement)
{
    // call super-class
    TextBlock::setAttributesOnNode(doc, blockElement);
    // local attributes
    if (m_contentType != AutoGenerated)
        blockElement.setAttribute("contentType", getContentType());
}

void CodeBlock::loadFromXMI ( QDomElement & root )
{
    setAttributesFromNode(root);
}

void CodeBlock::setAttributesFromNode (QDomElement & elem)
{
    // set attributes from the XMI in super-class
    TextBlock::setAttributesFromNode(elem);
    // set local fields now
    setContentType(((ContentType) elem.attribute("contentType","0").toInt()));
}

void CodeBlock::setAttributesFromObject(TextBlock * obj)
{
    TextBlock::setAttributesFromObject(obj);
    CodeBlock * cb = dynamic_cast<CodeBlock*>(obj);
    if (cb)
        setContentType(cb->getContentType());
}

QString CodeBlock::enumToString(const ContentType& val)
{
    if (val == AutoGenerated) {
        return QString("AutoGenerated");
    }
    else {
        return QString("UserGenerated");
    }
}

QTextStream& operator<<(QTextStream& str, const CodeBlock& obj)
{
    str << "CodeBlock: " << CodeBlock::enumToString(obj.getContentType())
        << ", ..." << static_cast<TextBlock*>(const_cast<CodeBlock*>(&obj));
    return str;
}


#include "codeblock.moc"
