// QMenuBar.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// Regenerated by Adam Treat on August 03 2002
//
// TODO
// o Override Dispose method, make sure slots are disconnected.

namespace Qt {

    using Qt;
    using System;
	using System.Collections;
    using System.Runtime.InteropServices;

    public class QMenuBar : QFrame, IQMenuData, IDisposable {

		private Hashtable menuConnections;

        public Hashtable MenuConnections {
			get { return menuConnections; }
		}

        public enum Separator {
            Never = 0,
            InWindowsStyle = 1
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_new_QMenuBar (IntPtr parent, string name);
        public QMenuBar (QWidget parent, string name) : this (QNull.Instance)
        {
            qparent = parent;
            if (qparent == null) parent = new QWidget (IntPtr.Zero);
            rawObject = qt_new_QMenuBar (parent.RawObject, name);
            if (qparent == null) RegisterObject (this);
            else qparent.AddChild (this);
        }

        public QMenuBar () : this (new QWidget ()) {}

        public QMenuBar (QWidget parent) : this (parent, "") {}

        internal QMenuBar (IntPtr ptr) : this (QNull.Instance)
        {
            rawObject = ptr;
            RegisterObject(this);
        }

        internal QMenuBar (QNull dummy) : base (QNull.Instance)
		{
			menuConnections = new Hashtable();
		}

        ~QMenuBar ()
        {
            Dispose (false);
        }

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QMenuBar (IntPtr obj);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QMenuBar (rawObject);
			deleted = true;
		}

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_updateItem (IntPtr raw, int identifier);
        public void UpdateItem (int identifier)
        {
            qt_QMenuBar_updateItem (rawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_show (IntPtr raw);
        public void Show ()
        {
            qt_QMenuBar_show (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_hide (IntPtr raw);
        public void Hide ()
        {
            qt_QMenuBar_hide (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuBar_eventFilter (IntPtr raw, IntPtr arg1, IntPtr arg2);
        public bool EventFilter (QObject arg1, QEvent arg2)
        {
            return qt_QMenuBar_eventFilter (rawObject, arg1.RawObject, arg2.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuBar_heightForWidth (IntPtr raw, int arg1);
        public int HeightForWidth (int arg1)
        {
            return qt_QMenuBar_heightForWidth (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern QMenuBar.Separator qt_QMenuBar_separator (IntPtr raw);
        public QMenuBar.Separator TheSeparator ()
        {
            return qt_QMenuBar_separator (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_setSeparator (IntPtr raw, QMenuBar.Separator when);
        public void SetSeparator (QMenuBar.Separator when)
        {
            qt_QMenuBar_setSeparator (rawObject, when);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_setDefaultUp (IntPtr raw, bool arg1);
        public void SetDefaultUp (bool arg1)
        {
            qt_QMenuBar_setDefaultUp (rawObject, arg1);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuBar_isDefaultUp (IntPtr raw);
        public bool IsDefaultUp ()
        {
            return qt_QMenuBar_isDefaultUp (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuBar_customWhatsThis (IntPtr raw);
        public bool CustomWhatsThis ()
        {
            return qt_QMenuBar_customWhatsThis (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuBar_sizeHint (IntPtr raw);
        public QSize SizeHint ()
        {
            return (QSize)LookupObject (qt_QMenuBar_sizeHint (rawObject), typeof(QSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuBar_minimumSize (IntPtr raw);
        public QSize MinimumSize ()
        {
            return (QSize)LookupObject (qt_QMenuBar_minimumSize (rawObject), typeof(QSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuBar_minimumSizeHint (IntPtr raw);
        public QSize MinimumSizeHint ()
        {
            return (QSize)LookupObject (qt_QMenuBar_minimumSizeHint (rawObject), typeof(QSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_activateItemAt (IntPtr raw, int index);
        public void ActivateItemAt (int index)
        {
            qt_QMenuBar_activateItemAt (rawObject, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_initialize ();
        public static void Initialize ()
        {
            qt_QMenuBar_initialize ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_cleanup ();
        public static void Cleanup ()
        {
            qt_QMenuBar_cleanup ();
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_drawContents (IntPtr raw, IntPtr arg1);
        protected void DrawContents (QPainter arg1)
        {
            qt_QMenuBar_drawContents (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_fontChange (IntPtr raw, IntPtr arg1);
        protected void FontChange (QFont arg1)
        {
            qt_QMenuBar_fontChange (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_menuContentsChanged (IntPtr raw);
        protected void MenuContentsChanged ()
        {
            qt_QMenuBar_menuContentsChanged (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_menuStateChanged (IntPtr raw);
        protected void MenuStateChanged ()
        {
            qt_QMenuBar_menuStateChanged (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_styleChange (IntPtr raw, IntPtr arg1);
        protected void StyleChange (QStyle arg1)
        {
            qt_QMenuBar_styleChange (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuBar_itemAtPos (IntPtr raw, IntPtr arg1);
        protected int ItemAtPos (QPoint arg1)
        {
            return qt_QMenuBar_itemAtPos (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuBar_hidePopups (IntPtr raw);
        protected void HidePopups ()
        {
            qt_QMenuBar_hidePopups (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuBar_itemRect (IntPtr raw, int item);
        protected QRect ItemRect (int item)
        {
            return (QRect)LookupObject (qt_QMenuBar_itemRect (rawObject, item), typeof(QRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuBar_QMenuData (IntPtr raw);
        public IntPtr QMenuData ()
        {
            return qt_QMenuBar_QMenuData (rawObject);
        }

        // Begin interface methods.


		//********************* A temporary hack to divert connections to CSharpConnect *****************//

		// This makes my brain hurt!
		// :-) Mine too!

		public int InsertItem (string text, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, text, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier, int index)
		{
			int id = InsertItem (icon, pixmap, identifier, index);
			SetAccel (accel, id);
			ConnectItem (id, receiver, member);
			return id;
		}

		public bool ConnectItem (int identifier, QObject receiver, string member)
		{
			return Qt.QMenuData.ConnectItem (this, QMenuData (), identifier, receiver, member);

		}

		public bool DisconnectItem (int identifier, QObject receiver, string member)
		{
			return Qt.QMenuData.DisconnectItem (this, QMenuData (), identifier, receiver, member);
		}

		//********************* A temporary hack to divert connections to CSharpConnect *****************//


        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern uint qt_QMenuData_count (IntPtr raw);
        public uint Count ()
        {
            return qt_QMenuData_count (QMenuData ());
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem4 (IntPtr raw, IntPtr text, int identifier, int index);
        public int InsertItem (string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem4 (QMenuData (), new QString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem5 (IntPtr raw, IntPtr icon, IntPtr text, int identifier, int index);
        public int InsertItem (QIconSet icon, string text, int identifier, int index)
        {
            return qt_QMenuData_insertItem5 (QMenuData (), icon.RawObject, new QString (text).RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem6 (IntPtr raw, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (string text, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem6 (QMenuData (), new QString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem7 (IntPtr raw, IntPtr icon, IntPtr text, IntPtr popup, int identifier, int index);
        public int InsertItem (QIconSet icon, string text, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem7 (QMenuData (), icon.RawObject, new QString (text).RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem8 (IntPtr raw, IntPtr pixmap, int identifier, int index);
        public int InsertItem (QPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem8 (QMenuData (), pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem9 (IntPtr raw, IntPtr icon, IntPtr pixmap, int identifier, int index);
        public int InsertItem (QIconSet icon, QPixmap pixmap, int identifier, int index)
        {
            return qt_QMenuData_insertItem9 (QMenuData (), icon.RawObject, pixmap.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem10 (IntPtr raw, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (QPixmap pixmap, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem10 (QMenuData (), pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem11 (IntPtr raw, IntPtr icon, IntPtr pixmap, IntPtr popup, int identifier, int index);
        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup, int identifier, int index)
        {
            return qt_QMenuData_insertItem11 (QMenuData (), icon.RawObject, pixmap.RawObject, popup.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem12 (IntPtr raw, IntPtr widget, int identifier, int index);
        public int InsertItem (QWidget widget, int identifier, int index)
        {
            return qt_QMenuData_insertItem12 (QMenuData (), widget.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem13 (IntPtr raw, IntPtr icon, IntPtr custom, int identifier, int index);
        public int InsertItem (QIconSet icon, QCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem13 (QMenuData (), icon.RawObject, custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertItem14 (IntPtr raw, IntPtr custom, int identifier, int index);
        public int InsertItem (QCustomMenuItem custom, int identifier, int index)
        {
            return qt_QMenuData_insertItem14 (QMenuData (), custom.RawObject, identifier, index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_insertSeparator (IntPtr raw, int index);
        public int InsertSeparator (int index)
        {
            return qt_QMenuData_insertSeparator (QMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItem (IntPtr raw, int identifier);
        public void RemoveItem (int identifier)
        {
            qt_QMenuData_removeItem (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_removeItemAt (IntPtr raw, int index);
        public void RemoveItemAt (int index)
        {
            qt_QMenuData_removeItemAt (QMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_clear (IntPtr raw);
        public void Clear ()
        {
            qt_QMenuData_clear (QMenuData ());
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_accel (IntPtr raw, int identifier);
        public QKeySequence Accel (int identifier)
        {
            return (QKeySequence)LookupObject (qt_QMenuData_accel (QMenuData (), identifier), typeof(QKeySequence));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setAccel (IntPtr raw, IntPtr key, int identifier);
        public void SetAccel (QKeySequence key, int identifier)
        {
            qt_QMenuData_setAccel (QMenuData (), key.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_iconSet (IntPtr raw, int identifier);
        public QIconSet IconSet (int identifier)
        {
            return (QIconSet)LookupObject (qt_QMenuData_iconSet (QMenuData (), identifier), typeof(QIconSet));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_text (IntPtr raw, int identifier);
        public string Text (int identifier)
        {
			QString qstr = new QString (qt_QMenuData_text (QMenuData (), identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_pixmap (IntPtr raw, int identifier);
        public QPixmap Pixmap (int identifier)
        {
            return (QPixmap)LookupObject (qt_QMenuData_pixmap (QMenuData (), identifier), typeof(QPixmap));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setWhatsThis (IntPtr raw, int identifier, IntPtr arg1);
        public void SetWhatsThis (int identifier, string arg1)
        {
            qt_QMenuData_setWhatsThis (QMenuData (), identifier, new QString (arg1).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_whatsThis (IntPtr raw, int identifier);
        public string WhatsThis (int identifier)
        {
			QString qstr = new QString (qt_QMenuData_whatsThis (QMenuData (), identifier));
			string str = qstr.Latin1 ();
			qstr.Dispose ();
			return str;
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem (IntPtr raw, int identifier, IntPtr text);
        public void ChangeItem (int identifier, string text)
        {
            qt_QMenuData_changeItem (QMenuData (), identifier, new QString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem1 (IntPtr raw, int identifier, IntPtr pixmap);
        public void ChangeItem (int identifier, QPixmap pixmap)
        {
            qt_QMenuData_changeItem1 (QMenuData (), identifier, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem2 (IntPtr raw, int identifier, IntPtr icon, IntPtr text);
        public void ChangeItem (int identifier, QIconSet icon, string text)
        {
            qt_QMenuData_changeItem2 (QMenuData (), identifier, icon.RawObject, new QString (text).RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem3 (IntPtr raw, int identifier, IntPtr icon, IntPtr pixmap);
        public void ChangeItem (int identifier, QIconSet icon, QPixmap pixmap)
        {
            qt_QMenuData_changeItem3 (QMenuData (), identifier, icon.RawObject, pixmap.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem4 (IntPtr raw, IntPtr text, int identifier);
        public void ChangeItem (string text, int identifier)
        {
            qt_QMenuData_changeItem4 (QMenuData (), new QString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem5 (IntPtr raw, IntPtr pixmap, int identifier);
        public void ChangeItem (QPixmap pixmap, int identifier)
        {
            qt_QMenuData_changeItem5 (QMenuData (), pixmap.RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_changeItem6 (IntPtr raw, IntPtr icon, IntPtr text, int identifier);
        public void ChangeItem (QIconSet icon, string text, int identifier)
        {
            qt_QMenuData_changeItem6 (QMenuData (), icon.RawObject, new QString (text).RawObject, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemActive (IntPtr raw, int identifier);
        public bool IsItemActive (int identifier)
        {
            return qt_QMenuData_isItemActive (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemEnabled (IntPtr raw, int identifier);
        public bool IsItemEnabled (int identifier)
        {
            return qt_QMenuData_isItemEnabled (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemEnabled (IntPtr raw, int identifier, bool enable);
        public void SetItemEnabled (int identifier, bool enable)
        {
            qt_QMenuData_setItemEnabled (QMenuData (), identifier, enable);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_isItemChecked (IntPtr raw, int identifier);
        public bool IsItemChecked (int identifier)
        {
            return qt_QMenuData_isItemChecked (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setItemChecked (IntPtr raw, int identifier, bool check);
        public void SetItemChecked (int identifier, bool check)
        {
            qt_QMenuData_setItemChecked (QMenuData (), identifier, check);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_indexOf (IntPtr raw, int identifier);
        public int IndexOf (int identifier)
        {
            return qt_QMenuData_indexOf (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_idAt (IntPtr raw, int index);
        public int IdAt (int index)
        {
            return qt_QMenuData_idAt (QMenuData (), index);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_setId (IntPtr raw, int index, int identifier);
        public void SetId (int index, int identifier)
        {
            qt_QMenuData_setId (QMenuData (), index, identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern bool qt_QMenuData_setItemParameter (IntPtr raw, int identifier, int param);
        public bool SetItemParameter (int identifier, int param)
        {
            return qt_QMenuData_setItemParameter (QMenuData (), identifier, param);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QMenuData_itemParameter (IntPtr raw, int identifier);
        public int ItemParameter (int identifier)
        {
            return qt_QMenuData_itemParameter (QMenuData (), identifier);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem (IntPtr raw, int identifier);
        public QMenuItem FindItem (int identifier)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findItem (QMenuData (), identifier), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findItem1 (IntPtr raw, int identifier, IntPtr parent);
        public QMenuItem FindItem (int identifier, QMenuData parent)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findItem1 (QMenuData (), identifier, parent.RawObject), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QMenuData_findPopup (IntPtr raw, IntPtr arg1, int[] index);
        public QMenuItem FindPopup (QPopupMenu arg1, int[] index)
        {
            return (QMenuItem)LookupObject (qt_QMenuData_findPopup (QMenuData (), arg1.RawObject, index), typeof(QMenuItem));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuInsPopup (IntPtr raw, IntPtr arg1);
        protected void MenuInsPopup (QPopupMenu arg1)
        {
            qt_QMenuData_menuInsPopup (QMenuData (), arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QMenuData_menuDelPopup (IntPtr raw, IntPtr arg1);
        protected void MenuDelPopup (QPopupMenu arg1)
        {
            qt_QMenuData_menuDelPopup (QMenuData (), arg1.RawObject);
        }

        public int InsertItem (string text, QObject receiver, string member)
        {
            return InsertItem(text, receiver, member, new QKeySequence ());
        }

        public int InsertItem (string text, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (string text, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member)
        {
            return InsertItem(icon, text, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(icon, text, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(icon, text, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member)
        {
            return InsertItem(pixmap, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member)
        {
            return InsertItem(icon, pixmap, receiver, member, new QKeySequence ());
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QObject receiver, string member, QKeySequence accel, int identifier)
        {
            return InsertItem(icon, pixmap, receiver, member, accel, identifier, (int) -1);
        }

        public int InsertItem (string text)
        {
            return InsertItem(text, (int) -1);
        }

        public int InsertItem (string text, int identifier)
        {
            return InsertItem(text, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text)
        {
            return InsertItem(icon, text, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, int identifier)
        {
            return InsertItem(icon, text, identifier, (int) -1);
        }

        public int InsertItem (string text, QPopupMenu popup)
        {
            return InsertItem(text, popup, (int) -1);
        }

        public int InsertItem (string text, QPopupMenu popup, int identifier)
        {
            return InsertItem(text, popup, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QPopupMenu popup)
        {
            return InsertItem(icon, text, popup, (int) -1);
        }

        public int InsertItem (QIconSet icon, string text, QPopupMenu popup, int identifier)
        {
            return InsertItem(icon, text, popup, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap)
        {
            return InsertItem(pixmap, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, int identifier)
        {
            return InsertItem(pixmap, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap)
        {
            return InsertItem(icon, pixmap, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, int identifier)
        {
            return InsertItem(icon, pixmap, identifier, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QPopupMenu popup)
        {
            return InsertItem(pixmap, popup, (int) -1);
        }

        public int InsertItem (QPixmap pixmap, QPopupMenu popup, int identifier)
        {
            return InsertItem(pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup)
        {
            return InsertItem(icon, pixmap, popup, (int) -1);
        }

        public int InsertItem (QIconSet icon, QPixmap pixmap, QPopupMenu popup, int identifier)
        {
            return InsertItem(icon, pixmap, popup, identifier, (int) -1);
        }

        public int InsertItem (QWidget widget)
        {
            return InsertItem(widget, (int) -1);
        }

        public int InsertItem (QWidget widget, int identifier)
        {
            return InsertItem(widget, identifier, (int) -1);
        }

        public int InsertItem (QIconSet icon, QCustomMenuItem custom)
        {
            return InsertItem(icon, custom, (int) -1);
        }

        public int InsertItem (QIconSet icon, QCustomMenuItem custom, int identifier)
        {
            return InsertItem(icon, custom, identifier, (int) -1);
        }

        public int InsertItem (QCustomMenuItem custom)
        {
            return InsertItem(custom, (int) -1);
        }

        public int InsertItem (QCustomMenuItem custom, int identifier)
        {
            return InsertItem(custom, identifier, (int) -1);
        }

        public int InsertSeparator ()
        {
            return InsertSeparator((int) -1);
        }

        public QMenuItem FindPopup (QPopupMenu arg1)
        {
            return FindPopup(arg1, new int[]{0});
        }
    }
}
