
// include files for Qt
#include <qdir.h>
#include <qwidget.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>

// application specific includes
#include "|NAMELITTLE|doc.h"
#include "|NAMELITTLE|.h"
#include "|NAMELITTLE|view.h"

QList<|NAME|View> *|NAME|Doc::pViewList = 0L;

|NAME|Doc::|NAME|Doc(QWidget *parent, const char *name) : QObject(parent, name)
{
  if(!pViewList)
  {
    pViewList = new QList<|NAME|View>();
  }

  pViewList->setAutoDelete(true);
}

|NAME|Doc::~|NAME|Doc()
{
}

void |NAME|Doc::addView(|NAME|View *view)
{
  pViewList->append(view);
}

void |NAME|Doc::removeView(|NAME|View *view)
{
  pViewList->remove(view);
}
void |NAME|Doc::setURL(const KURL &url)
{
  doc_url=url;
}

const KURL& |NAME|Doc::URL() const
{
  return doc_url;
}

void |NAME|Doc::slotUpdateAllViews(|NAME|View *sender)
{
  |NAME|View *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }

}

bool |NAME|Doc::saveModified()
{
  bool completed=true;

  if(modified)
  {
    |NAME|App *win=(|NAME|App *) parent();
    int want_save = KMessageBox::warningYesNoCancel(win,
                                         i18n("The current file has been modified.\n"
                                              "Do you want to save it?"),
                                         i18n("Warning"));
    switch(want_save)
    {
      case KMessageBox::Yes:
           if (doc_url.fileName() == i18n("Untitled"))
           {
             win->slotFileSaveAs();
           }
           else
           {
             saveDocument(URL());
       	   };

       	   deleteContents();
           completed=true;
           break;

      case KMessageBox::No:
           setModified(false);
           deleteContents();
           completed=true;
           break;

      case KMessageBox::Cancel:
           completed=false;
           break;

      default:
           completed=false;
           break;
    }
  }

  return completed;
}

void |NAME|Doc::closeDocument()
{
  deleteContents();
}

bool |NAME|Doc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  doc_url.setFileName(i18n("Untitled"));

  return true;
}

bool |NAME|Doc::openDocument(const KURL& url, const char *format /*=0*/)
{
  QString tmpfile;
  KIO::NetAccess::download( url, tmpfile );
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////

  KIO::NetAccess::removeTempFile( tmpfile );

  modified=false;
  return true;
}

bool |NAME|Doc::saveDocument(const KURL& url, const char *format /*=0*/)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////

  modified=false;
  return true;
}

void |NAME|Doc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}
