package org.kde.koala;
import org.kde.qt.*;


/** {@link KURLRequester} emits these signals */
public interface KURLRequesterSignals {

/** 
 Emitted when the user changed the URL via the file dialog.
 The parameter contains the contents of the lineedit.
     
*/
	void urlSelected( String arg1 );
	void destroyed();

/** 
 Emitted when return or enter was pressed in the lineedit.
 The parameter contains the contents of the lineedit.
     
*/
	void returnPressed( String arg1 );

/** 
 Emitted before the filedialog is going to open. Connect
 to this signal to "configure" the filedialog, e.g. set the
 filefilter, the mode, a preview-widget, etc. It's usually
 not necessary to set a URL for the filedialog, as it will
 get set properly from the editfield contents.

 If you use multiple KURLRequesters, you can connect all of them
 to the same slot and use the given KURLRequester pointer to know
 which one is going to open.
     
*/
	void openFileDialog( KURLRequester arg1 );

/** 
 Emitted when the text in the lineedit changes.
 The parameter contains the contents of the lineedit.
     
*/
	void textChanged( String arg1 );
}

