/***************************************************************************
                            HTMLCollection.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An <code> HTMLCollection </code> is a list of nodes. An individual
 node may be accessed by either ordinal index or the node's <code>
 name </code> or <code> id </code> attributes. Note: Collections in
 the HTML DOM are assumed to be live meaning that they are
 automatically updated when the underlying document is changed.

 
 @short 
 An <code> HTMLCollection </code> is a list of nodes.
*/
public class  HTMLCollection implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected HTMLCollection(Class dummy){}

	private native void newHTMLCollection();
	public HTMLCollection() {
		newHTMLCollection();
	}
	private native void newHTMLCollection( HTMLCollection other);
	public HTMLCollection( HTMLCollection other) {
		newHTMLCollection( other);
	}
	protected native void finalize() throws InternalError;

/** 
 This attribute specifies the length or size of the list.

     
*/
	public native long length();

/** 
 This method retrieves a node specified by ordinal index. Nodes
 are numbered in tree order (depth-first traversal order).

     
*/
	public native DOMNode item( long index);

/** 
 This method retrieves a <code> Node </code> using a name. It
 first searches for a <code> Node </code> with a matching <code>
 id </code> attribute. If it doesn't find one, it then searches
 for a <code> Node </code> with a matching <code> name </code>
 attribute, but only on those elements that are allowed a name
 attribute.

     
*/
	public native DOMNode namedItem( String name);

/** 

 not part of the DOM
     
*/
	public native DOMNode base();
//	public native HTMLCollectionImpl handle();
	public native boolean isNull();
//	private native void newHTMLCollection( NodeImpl base, int type);
//	public HTMLCollection( NodeImpl base, int type) {
//		newHTMLCollection( base, type);
//	}
}
