//////////////////////////////////////////////////////////////         
//      $Id: findf.h,v 1.12 2001/07/28 08:14:05 mlaurent Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef FINDF_H
#define FINDF_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <qdir.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qfiledlg.h> 
#include <qgrpbox.h> 
#include <qchkbox.h>
#include <qlayout.h> 

// KDE headers
#include <kapp.h>
#include <kmenubar.h>
#include <klistview.h> 
#include <kdialogbase.h>

class FindF : public KDialogBase
{
  Q_OBJECT

public:

  FindF ( QWidget *parent = 0);
  ~FindF(); 
  void resizeEvent(QResizeEvent *);
  void dropEvent(QDropEvent *);
  void dragEnterEvent(QDragEnterEvent* e);

private:
  void doFind(const QString &str);
  // Do the actual search

  QLineEdit *value;
  QListView *tab;
  QVBoxLayout* vl;
  QVBoxLayout* vtop, vf;
    
  QHBoxLayout* hb;

signals:
    void findf_signal();
    void findf_done_signal();

public slots:
  void done_slot();
  void ok_slot();
  void search(QListViewItem *);
  void textChanged ( const QString & text);

};
#endif
