% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.get.indent.R, R/rk.set.indent.R
\name{rk.get.indent}
\alias{rk.get.indent}
\alias{rk.set.indent}
\title{Globally define the indentation string}
\usage{
rk.get.indent(escape = FALSE)

rk.set.indent(by = "\\t")
}
\arguments{
\item{escape}{Logical,
      if set to \code{TRUE} each occurring "\\t" will be escaped by an additional "\\".}

\item{by}{Character string, indentation string to be defined globally.}
}
\value{
\code{rk.set.indent} returns invisible(NULL), \code{rk.get.indent} a character string.
}
\description{
Many functions allow to manually set the indentation string that should be used
for code formatting. The default string used can be globally defined with \code{rk.set.indent},
so you don't have to specify it in each function call.
}
\details{
\code{rk.get.indent} returns the set value, which defaults to a tab character by default.
}
