% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.comment.reuse.R
\name{rk.comment.reuse}
\alias{rk.comment.reuse}
\title{Create REUSE comment for RKWard plugin code}
\usage{
rk.comment.reuse(
  author,
  contributor = "The RKWard Team <rkward-devel@kde.org>",
  project = "RKWard",
  url = "https://rkward.kde.org",
  license = c("GPL-2.0-or-later", "BSD-3-Clause", "LGPL-2.1-or-later",
    "GFDL-1.2-no-invariants-or-later", "CC0-1.0", "MIT")
)
}
\arguments{
\item{author}{Character string in \code{Full Name <mail@example.org>} format,
      naming the author of the plugin.}

\item{contributor}{Character string in \code{Full Name <mail@example.org>} format,
      naming the contributor of the plugin.}

\item{project}{Character string, name of the project this plugin is a part of.}

\item{url}{Character string, URL to the project homepage.}

\item{license}{Character string, one if the available license strings.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Can be used to write a REUSE compliant comments to the document headers of generated files. For this,
      use
the resulting object in calls to \code{\link[rkwarddev:rk.JS.doc]{rk.JS.doc}},
      \code{\link[rkwarddev:rk.XML.plugin]{rk.XML.plugin}},
\code{\link[rkwarddev:rk.XML.pluginmap]{rk.XML.pluginmap}},
      \code{\link[rkwarddev:rk.rkh.doc]{rk.rkh.doc}}, or
\code{\link[rkwarddev:rk.plugin.skeleton]{rk.plugin.skeleton}}.
}
\details{
Values of \code{author} and \code{contributor} should be provided in the format \code{Full Name <mail@example.org>}.
}
\examples{
reuse_comment <- rk.comment.reuse(
    author = "Foo Bar <foo@example.com>"
)
cat(pasteXML(reuse_comment))
}
