% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.varslot.R
\name{rk.XML.varslot}
\alias{rk.XML.varslot}
\title{Create a XML node "varslot" for RKWard plugins}
\usage{
rk.XML.varslot(
  label,
  source,
  property = NULL,
  required = FALSE,
  multi = FALSE,
  duplicates = FALSE,
  min = 1,
  any = 1,
  max = 0,
  dim = 0,
  min.len = 0,
  max.len = NULL,
  classes = NULL,
  types = NULL,
  id.name = "auto",
  help = NULL,
  component = rk.get.comp(),
  i18n = NULL
)
}
\arguments{
\item{label}{Character string, a text label for the varslot.}

\item{source}{Either a character string (the \code{id} name of the \code{varselector} to select variables
from),
      or an object of class \code{XiMpLe.node} (whose \code{id} will be extracted and used). If it is not
a \code{<valueselector>} node, you must also specify a valid property for the node.}

\item{property}{Character string,
      valid property for a XiMpLe node defined by \code{source}. In the XML code, it
will cause the use of \code{source_property} instead of \code{source}. Only used if \code{source} ist not a
\code{<valueselector>} node.}

\item{required}{Logical, whether the selection of variables is mandatory or not.}

\item{multi}{Logical, whether the varslot holds only one or several objects.}

\item{duplicates}{Logical,
      if \code{multi=TRUE} defines whether the same entry may be added multiple times. Sets \code{multi=TRUE}.}

\item{min}{If \code{multi=TRUE} defines how many objects must be selected. Sets \code{multi=TRUE}.}

\item{any}{If \code{multi=TRUE} defines how many objects must be selected at least if any
are selected at all. Sets \code{multi=TRUE}.}

\item{max}{If \code{multi=TRUE} defines how many objects can be selected in total
(0 means any number). Sets \code{multi=TRUE}.}

\item{dim}{The number of dimensions, an object needs to have. If \code{dim=0} any number
of dimensions is acceptable.}

\item{min.len}{The minimum length, an object needs to have.}

\item{max.len}{The maximum length, an object needs to have. If \code{NULL},
      defaults to the largest
integer number representable on the system.}

\item{classes}{An optional character vector,
      defining class names to which the selection must be limited.}

\item{types}{If you specify one or more variables types here,
      the varslot will only accept objects of those
types. Valid types are "unknown", "number", "string", "factor", "invalid". Optional,
      use with great care,
the user should not be prevented from making valid choices,
      and rkward does not always know the type
of a variable!}

\item{id.name}{Character vector, unique ID for the varslot.
If \code{"auto"}, the ID will be generated automatically from \code{label}.}

\item{help}{Character string or list of character values and XiMpLe nodes,
      will be used as the \code{text} value for a setting node in the .rkh file.
If set to \code{FALSE},
      \code{\link[rkwarddev:rk.rkh.scan]{rk.rkh.scan}} will ignore this node.
Also needs \code{component} to be set accordingly!}

\item{component}{Character string,
      name of the component this node belongs to. Only needed if you
want to use the scan features for automatic help file generation; needs \code{help} to be set
accordingly, too!}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create a XML node "varslot" for RKWard plugins
}
\examples{
\dontrun{
test.varselector <- rk.XML.varselector("Select some vars")
test.varslot <- rk.XML.varslot("Vars go here", source=test.varselector)
cat(pasteXML(test.varslot))
}
}
\seealso{
\code{\link[rkwarddev:rk.XML.vars]{rk.XML.vars}},
   \code{\link[rkwarddev:rk.XML.varselector]{rk.XML.varselector}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
