% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.JS.vars.R
\name{rk.JS.vars}
\alias{rk.JS.vars}
\title{Define variables in JavaScript code}
\usage{
rk.JS.vars(
  ...,
  var.prefix = NULL,
  modifiers = NULL,
  default = FALSE,
  join = "",
  check.modifiers = TRUE,
  getter = "getValue",
  guess.getter = FALSE,
  object.name = FALSE,
  methods = ""
)
}
\arguments{
\item{...}{Either one or more character strings (the names of the variables to define),
or objects of class \code{XiMpLe.node} with plugin XML nodes (whose ID will be extracted and used).}

\item{var.prefix}{A character string. will be used as a prefix for the JS variable names.}

\item{modifiers}{A character vector with modifiers you'd like to apply to the XML node property.}

\item{default}{Logical,
      if \code{TRUE} the default value (no special modifier) of the node will
also be defined. Does nothing if \code{modifiers=NULL}.}

\item{join}{A character string,
      useful for GUI elements which accept multiple objects (e.g., multi-varslots).
If \code{join} is something other than \code{""},
      these objects will be collapsed into one string when pasted,
joined by this string.}

\item{check.modifiers}{Logical,
      if \code{TRUE} the given modifiers will be checked for validity. Should only be
turned off if you know what you're doing.}

\item{getter}{A character string,
      naming the JavaScript function which should be used to get the values in the
actual plugin. Depending on the XML element, \code{"getString"},
      \code{"getBool"} or \code{"getList"} can be
useful alternatives. For backwards compatibility,
      the default is set to \code{"getValue"}.}

\item{guess.getter}{Logical,
      if \code{TRUE} try to get a good default getter function for JavaScript
variable values.}

\item{object.name}{Logical,
      if \code{TRUE} the JS variable name will roughly match the R object name. If the
object name contains dots,
      they will be removed and the JS name printed in camel code instead. Use this option
with great caution and do not combine it with \code{\link[rkwarddev:rk.JS.scan]{rk.JS.scan}},
      as it will likely result
in unusable code. \code{rk.JS.scan} examines XML nodes and therefore does not know any R object names.}

\item{methods}{An optional character vector of method calls to append to the getter function
(see \code{\link[rkwarddev:rk.JS.method]{rk.JS.method}}).}
}
\value{
An object of class \code{rk.JS.var}.
}
\description{
Define variables in JavaScript code
}
\note{
To get a list of the implemented modifiers in this package see \code{\link[rkwarddev:modifiers]{modifiers}}.
}
\examples{
# create three checkboxes
checkA <- rk.XML.cbox(label="Run Test A", value="A")
checkB <- rk.XML.cbox(label="Run Test B", value="B")
checkC <- rk.XML.cbox(label="Run Test C", value="C")
# define them by their ID in JavaScript
cat(rk.paste.JS(rk.JS.vars(list(checkA, checkB, checkC))))
}
\seealso{
\code{\link[rkwarddev:rk.JS.array]{rk.JS.array}},
   \code{\link[rkwarddev:echo]{echo}},
   \code{\link[rkwarddev:id]{id}},
   \code{\link[rkwarddev:modifiers]{modifiers}},
   \code{\link[rkwarddev:rk.JS.method]{rk.JS.method}}
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
