% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.JS.optionset.R
\name{rk.JS.optionset}
\alias{rk.JS.optionset}
\title{Evaluate optionset objects in plugin JavaScript}
\usage{
rk.JS.optionset(
  optionset,
  ...,
  loopvar = "i",
  collapse = ",\\\\n\\\\t",
  vars = FALSE,
  guess.getter = TRUE
)
}
\arguments{
\item{optionset}{A XiMpLe.node object, the full \code{<optionset>} node.}

\item{...}{The JavaScript code,
      optionally including the optioncolumn objects. This will become
the body of the for loop.}

\item{loopvar}{Character, name of the index variable used in the for loop.}

\item{collapse}{Character string,
      how all optioncolumns should be concatenated on the R code level
Hint: To place each one on a new line with tab indentation, set \code{collapse=",
     \\n\\t"}.}

\item{vars}{Logical,
      if \code{TRUE} all optioncolumn varaibles will be defined first. This is not
needed if \code{\link[rkwarddev:rk.JS.scan]{rk.JS.scan}} was already called.}

\item{guess.getter}{Logical,
      if \code{TRUE} try to get a good default getter function for JavaScript
variable values. Only relevant if \code{vars=TRUE}.}
}
\description{
This function scans an object generated by \code{\link[rkwarddev:rk.XML.optionset]{rk.XML.optionset}},
extract IDs of all optioncolumn objects and nest the JavaScript code you define via \code{...} inside
a for loop that iterates through all columns. Inside \code{...},
      you can use the column objects of
\code{\link[rkwarddev:rk.XML.optioncolumn]{rk.XML.optioncolumn}} to refer to the respective column,
\code{rk.JS.optionset} will use appropriate variables.
}
\details{
In case you simply want to define the variables, but not run the loop yet,
      set \code{vars=TRUE} and
leave \code{...} empty.
}
\examples{
# this example is taken from the plugin skeleton script
# first set up an optionset object
dep.optionset.packages <- rk.XML.optionset(
  content=rk.XML.frame(rk.XML.stretch(before=list(
    rk.XML.row(
      dep.pckg.name <- rk.XML.input("Package"),
      dep.pckg.min <- rk.XML.input("min"),
      dep.pckg.max <- rk.XML.input("max"),
      dep.pckg.repo <- rk.XML.input("Repository")
    )
  )), label="Depends on R packages"),
  optioncolumn=list(
    dep.optioncol.pckg.name <- rk.XML.optioncolumn(connect=dep.pckg.name,
      modifier="text"),
    dep.optioncol.pckg.min <- rk.XML.optioncolumn(connect=dep.pckg.min, modifier="text"),
    dep.optioncol.pckg.max <- rk.XML.optioncolumn(connect=dep.pckg.max, modifier="text"),
    dep.optioncol.pckg.repo <- rk.XML.optioncolumn(connect=dep.pckg.repo, modifier="text")
  )
)

# now translate it to JavaScript for loop
JS.optionset <- rk.JS.optionset(dep.optionset.packages,
  echo("c("),
  echo("name=\"", dep.optioncol.pckg.name, "\""),
  ite(dep.optioncol.pckg.min, echo(", min=\"", dep.optioncol.pckg.min, "\"")),
  ite(dep.optioncol.pckg.max, echo(", max=\"", dep.optioncol.pckg.max, "\"")),
  ite(dep.optioncol.pckg.repo, echo(", repository=\"", dep.optioncol.pckg.repo, "\"")),
  echo(")")
)
}
\seealso{
\code{\link[rkwarddev:rk.XML.optionset]{rk.XML.optionset}}, 
   \code{\link[rkwarddev:rk.XML.optioncolumn]{rk.XML.optioncolumn}}
}
