% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ite.R
\name{ite}
\alias{ite}
\title{Generate JavaScript if/then/else constructs}
\usage{
ite(ifjs, thenjs, elsejs = NULL)
}
\arguments{
\item{ifjs}{Either a character string to be placed in the brackets of an \code{if()} statement,
or an object of class \code{XiMpLe.node}. \code{rk.JS.arr} or \code{rk.JS.opt} (whose identifier will be used).}

\item{thenjs}{Either a character string,
      the code to be executed in case the \code{if()} statement is true,
or an object of class \code{XiMpLe.node}. \code{rk.JS.arr} or \code{rk.JS.opt} (whose identifier will be used).
The latter is especially useful in combination with \code{\link[rkwarddev:rk.JS.options]{rk.JS.options}}.
You can also give another object of class \code{rk.JS.ite}.}

\item{elsejs}{Like \code{thenjs},
      the code to be executed in case the \code{if()} statement is not true.}
}
\value{
An object of class \code{rk.JS.ite}
}
\description{
This function is very similar to \code{\link[base:ifelse]{ifelse}}. If you would like to use if conditions
directly, have a look at the \code{\link[rkwarddev:js]{js}} wrapper instead.
}
\examples{
# first create an example checkbox XML node
cbox1 <- rk.XML.cbox(label="foo", value="foo1", id.name="CheckboxFoo.ID")
# now some JavaScript generation
ite(cbox1, echo("bar <- \"", cbox1, "\""), echo("bar <- NULL"))
}
\seealso{
\code{\link[rkwarddev:js]{js}},
   \code{\link[rkwarddev:rk.paste.JS]{rk.paste.JS}},
   \code{\link[rkwarddev:rk.JS.vars]{rk.JS.vars}},
   \code{\link[rkwarddev:rk.JS.array]{rk.JS.array}},
   \code{\link[rkwarddev:rk.JS.options]{rk.JS.options}},
   \code{\link[rkwarddev:echo]{echo}},
   \code{\link[rkwarddev:id]{id}},
   \code{\link[rkwarddev:qp]{qp}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
