# Copyright 2010-2014 Meik Michalke <meik.michalke@hhu.de>
#
# This file is part of the R package rkwarddev.
#
# rkwarddev is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# rkwarddev is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with rkwarddev.  If not, see <http://www.gnu.org/licenses/>.


#' Create XML node "help" for RKWard plugins
#'
#' @param file A character string, the file name to be included as reference.
#' @return An object of class \code{XiMpLe.node}.
#' @export
#' @seealso
#'    \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
#' @examples
#' test.help <- rk.XML.help("some_file.rkh")
#' cat(pasteXML(test.help))

rk.XML.help <- function(file){
  node <- XMLNode("help", attrs=list(file=as.character(file)))
  return(node)
}
