# the plugin code was generated by this script
# you should not change the plugin code directly, but this script
# note: this script only creates objects in your workspace,
# *EXCEPT* for the last call, see below.

require(rkwarddev)
rkwarddev.required("0.08-2")

local({
  # set the output directory to overwrite the actual plugin
  output.dir <- tempdir()
  overwrite <- TRUE
  # if you set guess.getters to TRUE, the resulting code will need RKWard >= 0.6.0
  guess.getter <- TRUE
  rk.set.indent(by="  ")
  rk.set.empty.e(TRUE)
  update.translations <- TRUE

  ## you must first setwd() to $YOURSOURCES/rk.FactorAnalysis/inst/rkward for this to run properly
  rkfa.components.root <- normalizePath("rkwarddev_components")

  about.info <- rk.XML.about(
    name="rk.FactorAnalysis",
    author=c(
      person(
        given="Meik",
        family="Michalke",
        email="meik.michalke@hhu.de",
        role=c("aut","cre")
      )
    ),
    about=list(
      desc="RKWard GUI to conduct principal component and factor analysis",
      version="0.01-16",
      url="https://rkward.kde.org",
      long.desc="RKWard GUI to conduct principal component and factor analysis (using the psych package). Also includes dialogs for scree plots, correlation plots, VSS/MAP and parallel analysis."
    )
  )

  dependencies.info <- rk.XML.dependencies(
    dependencies=list(
      rkward.min="0.6.5"
    ),
    package=list(
      c(name="psych", min="1.1.10")
    )
  )


  ## Components
  source(file.path(rkfa.components.root, "component_PCA_FA.R"), local=TRUE)
  source(file.path(rkfa.components.root, "component_scree_plot.R"), local=TRUE)
  source(file.path(rkfa.components.root, "component_parallel_analysis.R"), local=TRUE)
  source(file.path(rkfa.components.root, "component_VSS_MAP.R"), local=TRUE)
  source(file.path(rkfa.components.root, "component_correlation_plot.R"), local=TRUE)
  source(file.path(rkfa.components.root, "component_KMO.R"), local=TRUE)
  # source(file.path(rkfa.components.root, "component_.R"), local=TRUE)


  #############
  ## if you run the following function call, files will be written to tempdir!
  #############
  # this is where it get's serious, that is, here all of the above is put together into one plugin

  rk.FactorAnalysis.dir <<- rk.plugin.skeleton(
    about.info,
    path=output.dir,
    guess.getter=guess.getter,
    xml=list(
      logic=lgc.sect,
      dialog=full.dialog
    ),
    js=list(
      globals="var isObrot;",
      results.header=FALSE,
      require="psych",
      calculate=js.calc,
      printout=js.print
    ),
    pluginmap=list(name="Factor analysis", hierarchy=list("analysis", "Factor analysis")),
    components=list(
      scree.component,
      crplt.component,
      prll.component,
      vss.component,
      KMO.component
    ),
    dependencies=dependencies.info,
    create=c("pmap", "xml", "js", "desc"),
    overwrite=overwrite,
    tests=FALSE,
  #  edit=TRUE,
  #  show=TRUE,
    load=TRUE,
    hints=FALSE
  )

  if(isTRUE(update.translations)){
    rk.updatePluginMessages(file.path(output.dir,"rk.FactorAnalysis","inst","rkward","rk.FactorAnalysis.pluginmap"))
  } else {}
})
