/*
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kabc/addressbook.h>
#include <kabc/resourcefile.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>

int main( int argc, char **argv )
{
  KAboutData aboutData( "addrtest", I18N_NOOP( "KDE Address Test" ),
                        "0.1", "Test Programm", KAboutData::License_GPL,
                        I18N_NOOP( "(c) 2003 Tobias Koenig" ) );

  KApplication::disableAutoDcopRegistration();
  KCmdLineArgs::init( argc, argv, &aboutData );

  KApplication app( false, false );

  KABC::AddressBook ab;

  // create a file resource
  KABC::Resource *res = new KABC::ResourceFile( "/home/tobias/Desktop/addrtest.vcf", "vcard" );

  if ( res ) {
    ab.addResource( res );

    if ( !ab.load() ) {
      qDebug( "ERROR: Unable to load address book!" );
      return 1;
    }
    
    KABC::Addressee addr;
    addr.setNameFromString( "Tobias Willi Koenig III" );
    addr.setBirthday( QDate( 1982, 07, 19 ) );
    addr.setNickName( "tokoe" );
    addr.setMailer( "mutt" );

    // TZ
    KABC::TimeZone tz( 60 );
    addr.setTimeZone( tz );

    // GEO
    KABC::Geo geo( 52.5, 13.36 );
    addr.setGeo( geo );

    addr.setTitle( "dude, the" );
    addr.setRole( "developer" );
    addr.setOrganization( "KDE e.V." );
    addr.setNote( "Yet another senseless note..." );
    addr.setProductId( "<noid>" );
//  addr.setRevision( QDate::currentDate() );
    addr.setSortString( "Koenig" );
    addr.setUrl( KURL( "http://wgess16.dyndns.org" ) );

    // CLASS
    KABC::Secrecy secrecy( KABC::Secrecy::Confidential );
    addr.setSecrecy( secrecy );

    // PHOTO or LOGO
    KABC::Picture photo;
    QImage img;
    if ( img.load( "face.png", "PNG" ) ) {
      photo.setData( img );
      photo.setType( "image/png" );
      addr.setPhoto( photo );
    }

    // SOUND
    // dito for sound

    addr.insertEmail( "tokoe@kde.org", true );  // preferred email
    addr.insertEmail( "tokoe82@yahoo.de", false );

    // TEL
    KABC::PhoneNumber phoneHome( "0351 4519780", KABC::PhoneNumber::Home );
    KABC::PhoneNumber phoneWork( "0351 2335411", KABC::PhoneNumber::Work );
    addr.insertPhoneNumber( phoneHome );
    addr.insertPhoneNumber( phoneWork );

    // KEY omitted because of internal changes in near future

    // ADR
    KABC::Address homeAddr( KABC::Address::Home );
    homeAddr.setStreet( "Eisenstuckstrasse 16" );
    homeAddr.setLocality( "Dresden" );
    homeAddr.setRegion( "Saxony" );
    homeAddr.setPostalCode( "01069" );
    homeAddr.setCountry( "Germany" );
    addr.insertAddress( homeAddr );

    addr.insertCategory( "LUG-Dresden-Members" );

    addr.insertCustom( "KADDRESSBOOK", "X-Anniversary", "21.04.2009" );

    ab.insertAddressee( addr ); // will be assigned to the standard resource
                                // automatically

    KABC::Ticket *ticket = ab.requestSaveTicket( res );
    if ( !ticket ) {
      qDebug( "WARNING: Resource is locked by other application!" );
    } else {
      if ( !ab.save( ticket ) ) {
        qDebug( "ERROR: Saving failed!" );
        return 1;
      }
    }

    return 0;
  } else {
    qDebug( "ERROR: Unable to create a resource!" );
    return 1;
  }
}
