dnl Copyright (c) 2005, Eric Crahen
dnl
dnl Permission is hereby granted, free of charge, to any person obtaining a copy
dnl of this software and associated documentation files (the "Software"), to deal
dnl in the Software without restriction, including without limitation the rights
dnl to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
dnl copies of the Software, and to permit persons to whom the Software is furnished
dnl to do so, subject to the following conditions:
dnl 
dnl The above copyright notice and this permission notice shall be included in all
dnl copies or substantial portions of the Software.
dnl 
dnl THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
dnl IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
dnl FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
dnl AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
dnl WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
dnl CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

dnl Find doxygen if it is available using the paramaeter path;
dnl otherwise just check the user path. If Doxygen is found the 
dnl executable is assigned to the DOXYGEN variable.

dnl Eric Crahen <zthread@code-foo.com>

dnl AM_WITH_DOXYGEN
AC_DEFUN([AM_WITH_DOXYGEN], 
[

  AC_ARG_WITH(doxygen,[  --with-doxygen=PATH     Path to doxygen (optional)], 
  [ AC_CHECK_PROG(DOXYGEN, doxygen, $withval/doxygen,,$withval) ],
  [ AC_PATH_PROG(DOXYGEN, doxygen,,$PATH) ])

])

NO_DOXYGEN_ERROR=<<EOT
This configuration requires Doxygen, by Dimitri van Heesch.
Visit www.stack.nl/~dimitri/doxygen/ for information about how to
obtain a copy. 

If you already have Doxygen and it was not detected you should try the
--with-doxygen option to specifiy the path to your doxygen executable.
EOT

dnl AM_WITH_DOXYGEN_REQUIRED
AC_DEFUN([AM_WITH_DOXYGEN_REQUIRED], 
[

  AM_WITH_DOXYGEN	
  if test x$DOXYGEN == x; then
    AC_MSG_ERROR(${NO_PTHREAD_ERROR})
  fi

])

