/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.functor;

/**
 * A common superclass for {@link IDeclarationElement} instances. This one has a
 * very simple implementation for modifiers. Only the presence of the modifier
 * string fragment in declared modifier string is checked.
 * 
 */
abstract public class DeclarationElement extends Declaration implements
		IDeclarationElement, IDeclarationBlock {

	final private String modifiers;

	final private String name;

	final private IDeclaration[] nestedDeclarations;

	public DeclarationElement(Object declarationContext, String name,
			String modifiers) {
		super(declarationContext);
		this.modifiers = modifiers;
		this.name = name;
		this.nestedDeclarations = null;
	}

	public DeclarationElement(Object declarationContext, String name,
			String modifiers, IDeclaration[] nestedDeclarations) {
		super(declarationContext);
		this.modifiers = modifiers;
		this.name = name;
		this.nestedDeclarations = nestedDeclarations;
	}

	public IDeclaration[] getDeclarations() {
		return nestedDeclarations;
	}

	public String getName() {
		return name;
	}

	public boolean hasModifier(String modifier) {
		if (modifiers == null) {
			return false;
		}
		return modifiers.indexOf(modifier) >= 0;
	}

	@Override
	public boolean isBlock() {
		return size() > 0;
	}

	public int size() {
		return nestedDeclarations == null ? 0 : nestedDeclarations.length;
	}

	@Override
	public String toString() {
		return "declaration <'" + getName() + "'> [" + modifiers + "]";
	}
}
