/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Param;
import com.google.caliper.api.Benchmark;
import com.google.caliper.api.VmParam;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Parsers;
import com.google.caliper.util.Util;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.text.ParseException;

public final class Parameter {
    private final Field field;
    private final Parser<?> parser;
    private final ImmutableList<String> defaults;
    static final ImmutableSet<String> RESERVED_NAMES = ImmutableSet.of((Object)"benchmark", (Object)"environment", (Object)"instrument", (Object)"measurement", (Object)"run", (Object)"trial", (Object[])new String[]{"vm"});
    private static final ImmutableList<String> ALL_BOOLEANS = ImmutableList.of((Object)"true", (Object)"false");

    public static Parameter create(Field field) throws InvalidBenchmarkException {
        return new Parameter(field);
    }

    public Parameter(Field field) throws InvalidBenchmarkException {
        if (Util.isStatic(field)) {
            throw new InvalidBenchmarkException("Parameter field '%s' must not be static", field.getName());
        }
        if (RESERVED_NAMES.contains((Object)field.getName())) {
            throw new InvalidBenchmarkException("Class '%s' uses reserved parameter name '%s'", field.getDeclaringClass(), field.getName());
        }
        this.field = field;
        field.setAccessible(true);
        Class type = Primitives.wrap(field.getType());
        try {
            this.parser = Parsers.conventionalParser(type);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidBenchmarkException("Type '%s' of parameter field '%s' has no recognized String-converting method; see <TODO> for details", type, field.getName());
        }
        this.defaults = Parameter.findDefaults(field);
        this.validate((ImmutableCollection<String>)this.defaults);
    }

    void validate(ImmutableCollection<String> values) throws InvalidBenchmarkException {
        for (String valueAsString : values) {
            try {
                this.parser.parse(valueAsString);
            }
            catch (ParseException e) {
                throw new InvalidBenchmarkException("Cannot convert value '%s' to type '%s': %s", valueAsString, this.field.getType(), e.getMessage());
            }
        }
    }

    String name() {
        return this.field.getName();
    }

    ImmutableList<String> defaults() {
        return this.defaults;
    }

    void inject(Benchmark benchmark, String value) {
        try {
            Object o = this.parser.parse(value);
            this.field.set(benchmark, o);
        }
        catch (ParseException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private static ImmutableList<String> findDefaults(Field field) {
        Object[] defaultsAsStrings = Parameter.getValuesFromParamAnnotation(field);
        if (defaultsAsStrings.length > 0) {
            return ImmutableList.copyOf((Object[])defaultsAsStrings);
        }
        Class<?> type = field.getType();
        if (type == Boolean.TYPE) {
            return ALL_BOOLEANS;
        }
        if (type.isEnum()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object enumConstant : type.getEnumConstants()) {
                builder.add((Object)enumConstant.toString());
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    private static String[] getValuesFromParamAnnotation(Field field) {
        return field.isAnnotationPresent(Param.class) ? field.getAnnotation(Param.class).value() : field.getAnnotation(VmParam.class).value();
    }
}

