/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xplot.h"

char *fgetline (char *buf, int max, FILE *f)
{
    register char
	*cp;
    
    while (1)
    {
	fgets (buf, max, f);                    /* read a line */
	if (feof (f))
	    return (NULL);

        /* 
           Peter S Galbraith <psg@debian.org>  Dec 22 1998
           XPlot failed to read in lines that began with a minus sign or
           a decimal point (A better fix would be to use a regular 
           expression library). I add those characters here:
        */
                                                /* skip lines that don't */
        if ( (buf [0] == '\n') ||               /* look right */
             (buf [0] != ' ' && 
              buf [0] != '.' && 
              buf [0] != '-' && 
              ! isdigit (buf [0])) 
           )
            continue;

        /* 
           Peter S Galbraith <psg@debian.or>  Dec 22 1998
           ...and again here:
        */
	for (cp = buf; *cp; cp++)               /* if a digit or . in buf */
	    if (isdigit (*cp) || *cp == '.' || *cp == '-')    /* return it */
		return (buf);
    }

    /* not reached */ 
}
