/**
 * Inspired by: http://dbus-cplusplus.sourceforge.net/
 */

#ifndef __SDBUSCPP_TOOLS_GENERATOR_UTILS_H
#define __SDBUSCPP_TOOLS_GENERATOR_UTILS_H

#include <string>
#include <sstream>
#include <iomanip>

const char *atomic_type_to_string(char t);

std::string stub_name(const std::string& name);

std::string signature_to_type(const std::string& signature);

std::string underscorize(const std::string& str);

constexpr const char* getHeaderComment() noexcept { return "\n/*\n * This file was automatically generated by sdbus-c++-xml2cpp; DO NOT EDIT!\n */\n\n"; }

std::string mangle_name (const std::string& name);

#endif  //__SDBUSCPP_TOOLS_GENERATOR_UTILS_H
