#
# VERSIONING
#
build-major=2
build-minor=1

# Third party libraries required by Argeo Build
ECJ_MAJOR=3
BNDLIB_BRANCH=7.0
SYSLOGGER_BRANCH=$(build-major).$(build-minor)

# The following variables are found in the sdk.mk file which is generated by the configure script:
# SDK_SRC_BASE      the base of the source code, typically the root of the cloned git repository
# SDK_BUILD_BASE    the base of the output
# JAVA_HOME         the base of the JDK used to build
A2_OUTPUT ?= $(SDK_BUILD_BASE)/a2
JVM ?= "$(JAVA_HOME)/bin/java"
JAVADOC ?= "$(JAVA_HOME)/bin/javadoc"

# GNU defaults
prefix ?= /usr/local
datarootdir ?= $(prefix)/share
exec_prefix ?= $(prefix)
libdir ?= $(exec_prefix)/lib

A2_INSTALL_TARGET ?= $(DESTDIR)$(datarootdir)/a2

# The following variables have default values which can be overriden
# A2_BASE           the space-separated directories where already built a2 categories can be found
A2_BASE ?=$(call uniq, $(A2_OUTPUT) $(A2_INSTALL_TARGET) $(A2_NATIVE_INSTALL_TARGET) /usr/local/share/a2 /usr/local/lib/a2 $(JAVA_HOME)/share/a2 $(JAVA_HOME)/lib/a2 /usr/share/a2 /usr/lib/a2)

#
# OS-SPECIFIC
#
KNOWN_ARCHS ?= x86_64 aarch64

MSYS_VERSION := $(if $(findstring Msys, $(shell uname -o)),$(word 1, $(subst ., ,$(shell uname -r))),0)

ifneq ($(OS),Windows_NT)
file_sep=/
file_path_sep=:

# Linux
ifeq ($(shell uname -s),Linux)
TARGET_OS ?= linux
HOST_ARCH ?= $(shell uname -m)
TARGET_ARCH ?= $(HOST_ARCH)
TARGET_OS_LIBS ?= gnu
shlib_prefix=lib
shlib_suffix=.so

ifeq ($(TARGET_ARCH),aarch64)
TARGET_DEB_ARCH=arm64
JMOD_TARGET_PLATFORM = linux-aarch64
else # we only support two architectures
TARGET_DEB_ARCH=amd64
JMOD_TARGET_PLATFORM = linux-amd64
endif
endif

# MacOS
ifeq ($(shell uname -s),Darwin)
TARGET_OS ?= macos
TARGET_OS_LIBS ?= std
shlib_prefix=lib
shlib_suffix=.dylib
ifeq ($(shell uname -m),arm64)
HOST_ARCH = aarch64
else
HOST_ARCH = x86_64
endif

TARGET_ARCH ?= $(HOST_ARCH)
ifeq ($(TARGET_ARCH),aarch64)
JMOD_TARGET_PLATFORM = macos-aarch64
else
# TODO verify
JMOD_TARGET_PLATFORM = macos-amd64
endif

endif

else
# Windows
HOST_OS ?= windows
TARGET_OS ?= $(HOST_OS)
shlib_prefix=
shlib_suffix=.dll
file_sep=\\
file_path_sep=;

# TODO detect MinGW/MSYS with environment variable MSYSTEM ?
ifeq ($(MSYS_VERSION),0)
# assume Intel
HOST_ARCH ?= x86_64
TARGET_OS_LIBS ?= std
else # MSYS
HOST_ARCH ?= $(shell uname -m)
TARGET_OS_LIBS ?= std
endif
TARGET_ARCH ?= $(HOST_ARCH)

ifeq ($(TARGET_ARCH),aarch64)
# TODO verify
JMOD_TARGET_PLATFORM = windows-aarch64
else
JMOD_TARGET_PLATFORM = windows-amd64
endif
endif

LOCAL_NATIVE_CATEGORY_PREFIX=$(HOST_ARCH)-$(TARGET_OS)-$(TARGET_OS_LIBS)

TARGET_NATIVE_CATEGORY_PREFIX ?= $(TARGET_ARCH)-$(TARGET_OS)-$(TARGET_OS_LIBS)

A2_NATIVE_OUTPUT=$(A2_OUTPUT)/lib
TARGET_NATIVE_OUTPUT=$(A2_NATIVE_OUTPUT)/$(TARGET_NATIVE_CATEGORY_PREFIX)
TARGET_NATIVE_CATEGORY=$(TARGET_NATIVE_OUTPUT)/$(A2_CATEGORY)
A2_NATIVE_INSTALL_TARGET ?= $(DESTDIR)$(libdir)/${TARGET_NATIVE_CATEGORY_PREFIX}

PORTABLE_CATEGORIES=$(filter-out lib/% os/%, $(CATEGORIES))
NATIVE_CATEGORIES=$(filter $(TARGET_NATIVE_CATEGORY_PREFIX)/%, $(CATEGORIES))
OS_CATEGORIES=$(filter os/%, $(CATEGORIES))

##
## SETUP
##
$(A2_NATIVE_OUTPUT)/local:
	mkdir -p  $(A2_NATIVE_OUTPUT)/${LOCAL_NATIVE_CATEGORY_PREFIX}
	cd  $(A2_NATIVE_OUTPUT) && ln -s ${LOCAL_NATIVE_CATEGORY_PREFIX} local

a2-prepare-output: $(A2_NATIVE_OUTPUT)/local

# Layer version
ifeq ($(qualifier),.next)
ifneq ($(shell which git),)
ifeq ($(shell git rev-parse --is-inside-work-tree),true)
git_commit_count=$(shell git rev-list --count $(major).$(minor).$(micro)..HEAD)
git_head_shorthash=$(shell git rev-parse --short=7 HEAD)
ifneq ($(git_commit_count),)
undefine qualifier
qualifier=.$(shell printf "%04d" $(git_commit_count))-$(git_head_shorthash)
endif
endif
endif
endif

ifneq ($(git_commit_count),)
A2_LAYER_VERSION=$(major).$(minor).$(micro).$(git_commit_count)
else
A2_LAYER_VERSION=$(major).$(minor).$(micro)$(qualifier)
endif

##
## UTILITIES
##
# Install to a target directory without executable bit
INSTALL=install -m644 -D --target-directory

ifeq ($(HOST_OS),linux) # always try copy-on-write
COPY=cp --reflink=auto
else # MSYS, MacOS
COPY=cp
endif

# Recursively delete directories
RMDIR=$(RM) -r

# Reverse list
# see https://stackoverflow.com/questions/52674/simplest-way-to-reverse-the-order-of-strings-in-a-make-variable/14260762#14260762
reverse = $(if $(wordlist 2,2,$(1)),$(call reverse,$(wordlist 2,$(words $(1)),$(1))) $(firstword $(1)),$(1))

# Remove duplicates
# see https://stackoverflow.com/questions/16144115/makefile-remove-duplicate-words-without-sorting/16151140#16151140
uniq = $(strip $(if $1,$(firstword $1) $(call uniq,$(filter-out $(firstword $1),$1))))

# Make variables used to replace spaces by a separator, typically in order to generate classpaths
# for example: CLASSPATH = $(subst $(space),$(pathsep),$(strip $(JARS)))
null  :=
space := $(null) $(null)
comma := ,
pathsep := :
define LF

$(null)
endef

# Join list with the given separator and remove duplicates
define join_list # (separator, spaceSeparatedList)
$(subst $(space),$(1),$(call uniq,$(2)))
endef 

#
# GLOBAL REFERENCES
#
# see https://www.iana.org/assignments/enterprise-numbers/?q=48308
ARGEO_ENTERPRISE_NUMBER_OID=1.3.6.1.4.1.48308
# see https://www.rfc-editor.org/rfc/rfc9562
# uuidgen --sha1 --namespace 6ba7b812-9dad-11d1-80b4-00c04fd430c8 --name 1.3.6.1.4.1.48308 
ARGEO_ENTERPRISE_NUMBER_UUID=58873947-460c-59a6-a7b4-28a97def5f27
